@echo off
rem echo on
rem Note: Creating EPS-files does not work if contour-plots
rem are being made. In such a case, the set term/set output 
rem commands have to be moved in the tmp-file, such that they
rem come after the creation of the data-file.

set term=windows
set format=scr to screen output
set outtype=scr
set fontsize=

if "%1" == "" goto help

if exist %GNUPLOTEXEC% goto loop
if exist c:\progra~1\gnuplot\bin\wgnuplot.exe set GNUPLOTEXEC=c:\progra~1\gnuplot\bin\wgnuplot.exe
if exist c:\progra~1\ox\packages\tsmod32\wgnuplot.exe set GNUPLOTEXEC=c:\progra~1\ox\packages\tsmod32\wgnuplot.exe
if exist c:\progra~1\ox\packages\tsmod40\wgnuplot.exe set GNUPLOTEXEC=c:\progra~1\ox\packages\tsmod40\wgnuplot.exe
if exist c:\progra~1\ox\packages\tsmod4\wgnuplot.exe set GNUPLOTEXEC=c:\progra~1\ox\packages\tsmod4\wgnuplot.exe
if not exist %GNUPLOTEXEC% set GNUPLOTEXEC=wgnuplot.exe

:loop
  if "%1" == "" goto end
  if not "%1" == "-size" goto nosize
    set outs1=%2
    set outs2=%3
    set setoutsize=true
    shift
    shift
    goto endloop
  :nosize
  if not "%1" == "-fontsize" goto nofont
    set fontsize=%2
    shift
    goto endloop
  :nofont
  if not "%1" == "-scr" goto noscr
    set outtype=scr
    set format=scr to screen output
    set term=windows
    goto endloop
  :noscr
  if not "%1" == "-bw" goto nobw
    set outtype=scr
    set format=scr to screen output
    set term=windows monochrome
    goto endloop
  :nobw
  if not "%1" == "-eps" goto noeps
    set outtype=eps
    set format=eps in encapsulated postscript format
    set term=postscript eps monochrome
    goto endloop
  :noeps
  if not "%1" == "-epsc" goto noepsc
    set outtype=eps
    set format=eps in encapsulated postscript format
    set term=postscript eps color
    goto endloop
  :noepsc
  if not "%1" == "-fig" goto nofig
    set outtype=fig
    set format=fig in fig format
    set term=fig color
    if not "%outs1%" == "" set term=%term% size %outs1% %outs2%
    set setoutsize=false
    goto endloop
  :nofig
  if not "%1" == "-gif" goto nogif
    set outtype=gif
    set format=gif in gif format
    set term=gif small
    if not "%outs1%" == "" set term=%term% size %outs1%,%outs2%
    set setoutsize=false
    goto endloop
  :nogif
  if not "%1" == "-png" goto nopng
    set outtype=png
    set format=png in png format
    set term=png small
    if not "%outs1%" == "" set term=%term% size %outs1%,%outs2%
    set setoutsize=false
    goto endloop
  :nopng
  if not "%1" == "-tex" goto notex
    set outtype=aux
    set format=aux in PSLaTeX format
    set term=pslatex
    goto endloop
  :notex    
  
  rem Here a file should be found...
  if not exist %1.plb goto error

  set outfile=%1.tmp
  echo # Writing file %1.%format% >%outfile%
  echo reset >>%outfile%
  echo set terminal %term% >>%outfile%
  rem Set fontsize
  if "%fontsize%" == "" goto wrout
    echo set termoption font ',%fontsize%' >>%outfile%

  :wrout
  if "%outtype%"=="scr" goto wrlabel
    echo set output '%1.%outtype%' >>%outfile%
    goto wrsize
  :wrlabel  
    echo set label '%1.plb' at screen 1,0.98 right>>%outfile%
  :wrsize
  if not "%setoutsize%"=="true" goto wrplb
    echo set size %outs1%,%outs2% >>%outfile%
  :wrplb
  type %1.plb >>%outfile%

  if "%outtype%"=="scr" goto pausemouse

  set arg=
  echo set terminal unknown >>%outfile%
  echo set output >>%outfile%
  echo Writing %1.%outtype%
  
  goto callgnuplot
  
  :pausemouse
  rem set arg=-
  echo pause mouse >> %outfile%

  :callgnuplot
  start /w %GNUPLOTEXEC% %outfile% %arg% 2>nul
  rem echo start /w %GNUPLOTEXEC% %outfile% %arg%
  if not errorlevel 1 goto dellog

  start /w wgnupl32.exe %outfile% %arg% 2>nul
  if not errorlevel 1 goto dellog

  echo Error: wgnuplot.exe nor wgnupl32.exe found in path. Install it in
  echo the path or in c:\program files\gnuplot\bin

  :dellog

  if "%GNU2PLT%"=="ON" copy %outfile% %1.plt >nul
  del %1*.log 2>nul
  del %outfile% 2>nul

  :endloop
  shift 
goto loop

:error
  echo Error: File %1.plb not found
:help
  echo "plb2x [-size x y] [-fontsize z] [-type] <filename1> [<filename2>]"
  echo "Call this script with optional size information for the graph."
  echo Please call this batchfile with the filename without extension
  echo as the argument.

:end
set outs1=
set outs2=
set setoutsize=
set fontsize=
set outfile=
set outtype=
set term=
set arg=
