/*--------------------------------------------------------------------------
 * gnudraw.h - definitions/declarations for GnuPlot drawing library
 *
 *       (C) Jurgen Doornik 1995
 *       Adapted for GnuPlot by Charles Bos, 2000
 *
 *--------------------------------------------------------------------------*/
#ifdef OXDRAW
  #include <oxdraw.h>
#endif  

#ifndef GNUDRAW_INCLUDED
#ifndef OXDRAW_INCLUDED
#define GNUDRAW_INCLUDED
#define OXDRAW_INCLUDED
#define GNUDRAW

#include <oxstd.h>

#pragma array_base(0) 

SetTextWindow(const sTitle);

SaveDrawWindow(const sFileName, ...);
SetDrawWindow(const sTitle);
ShowDrawWindow();
CloseDrawWindow();
DrawCorrelogram(const iArea, const vY, const sY, const cLag, ...);
DrawSpectrum(const iArea, const vY, const sY, const iOrder, ...);
DrawDensity(const iArea, const vY, const sY, ...);
DrawQQ(const iArea, const vY, const sY, const iDens, ...);
DrawBoxPlot(const iArea, const vY, const sY, ...);
DrawCdf(const iArea, const mX, const asX, ...);

DrawMatrix(const iArea, const mYt, const asY,
           const dXfirst, const dXstep, ...);
DrawTMatrix(const iArea, const mYt, const asY, ...);
DrawXMatrix(const iArea, const mYt, const asY,
    const vX, const sX, ...);

Draw(const iArea, const mYt, ...);
DrawT(const iArea, const mYt, const mnYear, const mnPeriod, const iFreq);
DrawX(const iArea, const mYt, const vX);

SetDraw(const iOption, ...);
DrawLine(const iArea, const dX1, const dY1, const dX2, const dY2, const iIndex, ...);
DrawPLine(const iArea, const iX1, const iY1, const iX2, const iY2, const iIndex);
DrawSymbol(const iArea, const dX1, const dY1, const dX2, const dY2,
        const iSymType, const iIndex);
DrawPSymbol(const iArea, const iX1, const iY1, const iX2, const iY2,
        const iSymType, const iIndex);
DrawTitle(const iArea, const sText);
DrawPText(const iArea, const sText, const iPx1, const iPy1, ...);
DrawText(const iArea, const sText, const dX1, const dY1, ...);
DrawLegend(const iArea, const iOffsX, const iOffsY, const fHidden);
DrawAxis(const iArea, const fIsXaxis, const dAnchor,
        const dAxmin, const dAxmax, const dFirstLarge, const dLargeStep,
        const dSmallStep, ...);
DrawAxisAuto(const iArea, const fIsXaxis, ...);
DrawAdjust(const iType, ...);
DrawZ(const vZ, ...);
DrawXYZ(const iArea, const vX, const vY, const mZ, ...);
DrawHistogram(const iArea, const vBar, ...);
DrawAcf(const iArea, const vY, const sY, const cLag, ...);

// New routines
DrawAbout();
DrawBivDensity(const iArea, const mY, const asY, const fDens,
               const fHist, const fNormal, ...);

// Debug routine
DrawDebug();               


enum
{   QQ_CHI, QQ_F, QQ_N, QQ_T, QQ_U, QQ_N_SE
};
enum
{
    SET_DEFAULT,        SET_MARGIN,         SET_BOX,
    SET_FONT,           SET_AXIS,           SET_AXISLINE,
    SET_GRID,           SET_LEGEND,         SET_LEGENDHIDE,
    SET_HISTOGRAM,      SET_COLOR,          SET_SYMBOL,
    SET_LINE,           SET_COLORMODEL,     SET_PRINTPAGE,
    SET_PALETTE_MAX,    SET_PALETTE_MIN,    SET_XYSTYLE,
    SET_PAPERCOLOR,     SET_BWG,            SET_LINEBWG,
    SET_AXISZEROS,      SET_AXISFORMAT,     SET_LEGENDRESIZE,
    SET_LEGENDFONTSIZE, SET_OUTPUT,         SET_LABDRAWZ,
    SET_JOIN,           SET_FILL
};
enum
{
        PAGE_A4 = 0,       PAGE_LETTER = 1,   PAGE_USER = 2,
        PAGE_PORTRAIT = 0, PAGE_LANDSCAPE = 1
};
enum
{
    PL_FILLBOX,                                               /* filled box */
    PL_BOX,                                                     /* open box */
    PL_PLUS,                                                        /* plus */
    PL_DASH,                                                        /* dash */
    PL_CIRCLE,                                                    /* circle */
    PL_NOSYMBOL,            /* leave at value 5 for backwards compatibility */
    PL_LINE = PL_NOSYMBOL,
    PL_FILLCIRCLE,
    PL_TRIANGLE,
    PL_FILLTRIANGLE,
    PL_DIAMOND,
    PL_FILLDIAMOND,
    PL_CROSS,
    PL_CNTSYMBOL, 
    PL_DOT= PL_CNTSYMBOL,
    PL_LAST
};
enum
{
    TP_SOLID,
    TP_DOTTED,
    TP_DASHED,
    TP_LDASHED,
    TP_USER
};
enum
{
	ST_LINE,
	ST_SYMBOLS,
	ST_LINESYMBOLS,
	ST_INDEX,
	ST_INDEXSYMBOLS,
	ST_BARS,
	ST_SHADING,
	ST_MAX = ST_SHADING
};
enum
{
    AXIS_LINEAR,
    AXIS_LOG,
    AXIS_LOG10,
    AXIS_SCALED,
    AXIS_DATE
};  
enum
{
    TEXT_TEXT,
    TEXT_TITLE,
    TEXT_XLABEL,
    TEXT_YLABEL,
    TEXT_ZLABEL,
    TEXT_AREA,
    TEXT_PANEL,
    TEXT_LAST
};
enum
{       ANCHOR_MIN, ANCHOR_MAX, ANCHOR_USER
};
enum
{   ZMODE_NONE = 0, ZMODE_SYMBOL, ZMODE_VALUE, ZMODE_BAR, ZMODE_BAND,
    ZMODE_HILO, ZMODE_3D, ZMODE_FAN,
    ZMODE_MESH = 256, ZMODE_TRIANGLE, ZMODE_COLOR
};
enum
{
	ADJ_COLOR,		ADJ_SYMBOL, 	ADJ_INDEX,
	ADJ_SCALE,		ADJ_MINMAX, 	ADJ_AXISHIDE,
	ADJ_AXISLINE,	ADJ_AXISGRID,	ADJ_SYMBOLUSE,
	ADJ_AREA_X,     ADJ_AREA_Y,     ADJ_AREA_P,
	ADJ_AREAMATRIX, ADJ_TEXTANGLE,	ADJ_AXISLABEL,
	ADJ_AREA_3D,	ADJ_3D_ROTATE,	ADJ_3D_RESET,
	ADJ_AREA_Z,     ADJ_AXISSCALE,	ADJ_AXISCENTRE,
	ADJ_AREA_3DSET, ADJ_PAPERSCALE, ADJ_LEGEND,
	ADJ_COLORMODEL, ADJ_PAPERCOLOR, ADJ_AREASCOLOR,
    // GnuDraw specials
    ADJ_ALIGN,      ADJ_AXES2ND,    ADJ_LABEL,
    ADJ_SHOW,       ADJ_CNTRPARAM,  ADJ_WARN,
    ADJ_AXISFORMAT, ADJ_AXISTEXT,   ADJ_FILLCURVE,  
    ADJ_ENCODING,   ADJ_DEBUG
};

// Static declaration for passing values within this file. 
static decl s_Fig= {};

// Constant, number of seconds/days in a year according to GnuPlot
static decl G_GD_SEC= 365.4*24*60*60, G_GD_DAY= 365.4;

/* 
**  Figure contains
**    Figure[F_GLOB]: Global settings for the plots
**    Figure[F_PLOT]: Plots = array [nPlots]
**    Figure[F_NPLOTS]: nPlots = integer
**    Figure[F_SIZES]: Sizes= vector with XSize, YSize, XScale, YScale
**
**  Plot contains
**    Plot[0]: Lines = array [nLines]
**    Plot[1]: nLines = integer
**    Plot[2]: Set = array of strings, extra set
**                commands. See enumeration for index into array.
**    Plot[3]: Type= vector of booleans/integers [useKeys, iDMY, isXYZ, 
**                isContour, isFan, isGrid], indicating if keys are used, if
**                dates are  on x-axis (0= no, 1= x, 2= y, 3= xy, 4=z, etc), if
**                this  is an XYZ plot, if this is a contour plot, a fan plot,
**                or a grid plot
**    Plot[4]: Location= indication of the location of this plot in
**               the graphing window, with left-bottom corner x,y and
**               width, height.
**    Plot[5]: TicsAxisBorder= matrix of size 9 x 5 with 
**               row 0: show x, y zeroaxis, show full box, color x-grid,
**                      color y-grid
**               row 1: booleans, to indicate if tics should appear on the 
**                      x, y, z, x2, y2 axis (=1) or on the border (=0)
**               row 2: Use zeroaxis?
**               row 3-5: start, incr, end of major tics
**               row 6: incr of minor tics
**               row 7: grid in this direction, colour
**               row 8: grid in this direction, line type
**    Plot[6]: AxisLabel: vector of size 4 with rotation, font, size and
**               ticksize of axis labels
**    Plot[7]: Limits= 6x3 matrix with minimum, maximum, reverse as
**               set through ADJ_AREA_?.
**    Plot[8]: DateSpec= 1x6 (later: 3 x 6 or 6 x 6) matrix of booleans,
**               indicating if, for a  time series plot, YY, MM, DD, HH,
**               Min, SS are being specified
**    Plot[9]: Axis= integer, 0= x-axis, 1= y-axis, 2= z=axis, 3=
**              x2axis, 4= y2axis, 5= z2axis, last axis used
**    Plot[10]: Labels= array with {{sText},
**      vXYZ~iFontNo~iFontSize~iTitle~iJust~iRotation}
**      where iTitle= TEXT_TEXT,... etc, 
**        and iJust= -1, 0, 1 for left, center and right
**    Plot[11]: Legend= vector of size 9 with [iX, iY, bCoord, bRight, bReverse,
**      bBox, bHide, iCol, iFontsize]. Coordinates run from (0,0) to
**      (1,1) (top left to bottom right, within graphing area). If
**      bCoord is false, let GnuPlot put key in location. bRight adjusts
**      label to right, bReverse reverses label and line, bBox shows the
**      box, bHide hides the key, iCol and iFontsize are not yet
**      implemented.
**    Plot[12]: AxisScale= matrix of size 6 x 4, with type of
**               scale, scale and shift, with indicator of format, 
**               of x, y, z, x2, y2, z2-axis as
**               set through ADJ_AXISSCALE.
**    Plot[13]: 3DView= vector of size 4, with rot_x, rot_z, scale,
**              scale_z (in gnuplot speak) or azimuth, elevation,
**              distance, twist (in ox speak?).
**    Plot[14]: Colormodel= integer, color model
**    Plot[15]: AxisText= array of length 5, with for x/y/z/x2/y2 axis
**              an array of size 2, with array of size iL of text
**              labels, and vector of size iL with text locations
**
**  Line contains
**    Line[0]: XYZ= array [5] with mX, mY, mZ, vCol or xyzdiff, vSize, empty
**      whereever the element is not used
**    Line[1]: Type= array of string, integer, integer, 
**                integer, where string contains linestyle, then
**                linetype, linewidth, and number of contours/contour levels
**    Line[2]: Key= string
**    Line[3]: Axes= vector of 3 booleans, if using second x/y/z axis
**              (but z2 axis does not exist)
**    Line[4]: Point= vector of 3 integers, with point style, size
**    Line[5]: Skip= boolean; if true, line only contains missings, and
**                should be skipped
**
**  Global settings contain:
**    G_LASTPLOT    index of last plot window used
**    G_INITFIGURE  boolean, whether plot should be reinitialised
**    G_WARN        boolean, whether warnings should be printed
**    G_LOCATION    string, with location of legend
**    G_TEMPCOUNT   integer, counter for temporary files
**    G_ALIGN       0 or 2-vector with number of columns (x-direction), 
**                  number of rows (y-direction)
**    G_SHOW        boolean, if plots should be shown on screen
**    G_TITLE       array[3] with
**                    string, present window title
**                    array of strings, previously used window titles
**                    array of filehandles, open pipes to windows
**    G_DEFPOINT    vector of 2 integers, with default point style and size
**    G_DEFLINE     vector of 3 integer, default line index (2), type (0=lines)
**                       and width (M_NAN= 1)
**    G_DEFFILL     integer, fill density
**    G_DEFFONT     vector of 3 integers, with default font type (0) and
**                  size (300), and a boolean indicating enhanced fonts
**    G_LEGEND      vector of 9 integers, see plot[P_LEGEND]
**    G_GNUPLOTEXEC string, location of gnuplot executable in Windows
**    G_OXWINDOWS   integer, type of operating system
**    G_TERM        string, default output terminal
**    G_COLORMODEL  integer, default color model
**    G_BOX         vector of size 3, with box and x/y grid style
**    G_PAPERCOLOR  integer, background color (?)
**    G_COLORS      string, either classic, default, or podo, relating
**                  to new gnuplot settings
*/

enum {F_GLOB, F_PLOT, F_NPLOTS, F_SIZES, F_LAST};
enum {P_LINE, P_NLINES, P_SET, P_TYPE, P_LOCATION, P_TICSAXISBORDER,
      P_AXISLABEL, P_LIMITS, P_DATESPEC, P_AXIS, P_LABEL, P_LEGEND, 
      P_AXISSCALE, P_3DVIEW, P_COLORMODEL, P_PAPERCOLOR, P_AXISTEXT, P_LAST};
enum {L_XYZ, L_TYPE, L_KEY, L_AXES, L_POINT, L_SKIP, L_LAST};
// This enumeration is meant to provide for an index into aPlot[P_SET]
// where set- and unset commands for these gnuplot elements are given.
// Elements in the first element of aPlot[P_SET][] are executed before the 
// plot, in the second element before the next plot, if needed to reset the defaults.
enum {S_MULTIPLOT, S_SIZE, S_ORIGIN, 
      S_ARROW, S_KEY,
      S_BORDER, S_XZEROAXIS, S_YZEROAXIS, S_X2ZEROAXIS, S_Y2ZEROAXIS, S_ZZEROAXIS, 
      S_FORMAT, S_TIMEFMT, S_XDATA, 
      S_XRANGE, S_YRANGE, S_ZRANGE, S_X2RANGE, S_Y2RANGE, S_Z2RANGE, 
      S_ENCODING, S_LABEL, S_TITLE, S_XLABEL, S_YLABEL, S_ZLABEL,
      S_AXISSCALE,
      S_XYPLANE, S_TICSLEVEL, 
      S_XTICS, S_YTICS, S_X2TICS, S_Y2TICS, S_ZTICS, 
      S_MXTICS, S_MYTICS, S_MX2TICS, S_MY2TICS, S_MZTICS, 
      S_GRID,
      S_DGRID3D, S_HIDDEN3D, S_VIEW, S_SURFACE, 
      S_CLABEL, S_CONTOUR,
      S_CNTRPARAM, S_PM3D, S_PALETTE, S_COLORBOX,
      S_BOXWIDTH, S_BAR, 
      S_LAST};
// Types of plot, belonging to P_TYPE      
enum {T_USEKEYS, T_DMY, T_LOG, T_LOG10, T_XYZ, T_CONTOUR, T_FAN, T_GRID, T_LAST};
// Skipping P_Labs (Plot[2]), P_Location (Plot[6]) and P_range (Plot[7])

// Type of global settings for all figures
enum {G_LASTPLOT, G_INITFIGURE, G_WARN, G_LOCATION, 
      G_TEMPCOUNT, G_ALIGN, G_SHOW, G_TITLE, G_DEFPOINT,
      G_DEFLINE, G_DEFFILL, G_DEFFONT, G_LEGEND, G_GNUPLOTEXEC, G_GNUWINDIR, G_OXWINDOWS, G_TERM,
      G_COLORMODEL, G_LABDRAWZ, G_JOIN, G_BOX, G_PAPERCOLOR, G_COLORS, G_LAST}

// Distinct output types      
enum {O_X11, O_WXT, O_QT, O_WIN, O_PLB, O_EPS, O_PNG, O_GIF, O_TEX, O_ETEX, 
      O_SVG, O_PDF, O_FIG, O_EMF, O_LAST};
      
// For TSMod: comment in next lines
// extern s_RunTimeEnv();
// extern popen_C(const sGnuExec, const sType);
// extern pclose_C(const fh);
// extern fflush_C(const fh);

// For TSMod: Comment out next set of lines until END TSMOD marker
//   Instead, create a tsmgnu4.h file containing ONLY those same lines

/*
**  s_RunTimeEnv()
** 
**  Purpose:
**    Read at runtime some environment variables; should not be compiled
**
**  Return value:
**    Array with
**      bIsWindows  boolean, true if run on windows
**      sOS         string, type of Windows
**      sGnuDrawDir string, location of gnudraw
**      sWinDir     string, location of windows directory
**      sGnuPlot    string, location of gnuplot executable (if specified)
**      sDebug      string, value of DEBUG environment variable
*/
s_RunTimeEnv()
{
  decl bIsWindows;
  
  #ifdef OX_Windows
    bIsWindows= TRUE;
  #else
    bIsWindows= FALSE;
  #endif

//   if (s_XYZ_Debug)
//     println ("RunTimeEnv returns ", {bIsWindows, getenv("OS"), oxfilename(1), getenv("WINDIR"), 
//              getenv("GNUPLOTEXEC")});
  
  return {bIsWindows, getenv("OS"), oxfilename(1), getenv("WINDIR"), 
          getenv("GNUPLOTEXEC")};
}

#ifdef OX_Windows
  popen_C(const sGnuExec, const sType)
    {
      oxwarning ("popen_C not defined on this platform");
    }
  pclose_C(const fh)
    {
      oxwarning ("pclose_C not defined on this platform");
    }
  fflush_C(const fh)  
    {
      oxwarning ("fflush_C not defined on this platform");
    }
#else
  extern "packages/gnudraw/lib/gnupipe,popen_C" popen_C(const sGnuExec, const sType);
  extern "packages/gnudraw/lib/gnupipe,pclose_C" pclose_C(const fh);
  extern "packages/gnudraw/lib/gnupipe,fflush_C" fflush_C(const fh);
#endif

// Actual inclusion of code, which may be compiled
#import "packages/gnudraw/gnudraw"

#endif // OXDRAW_INCLUDED
#endif // GNUDRAW_INCLUDED

// END TSMOD marker

