/*
**  DrawACF
**
**  Purpose:
**    Display capabilities of DrawACF and DrawTitle
**
**  Date:
**    18/1/2002
**
**  Author:
**    Charles Bos
*/
#include <oxstd.h>      // Include the Ox standard library header
#include <arma.h>
#include <packages/gnudraw/gnudraw.h>

main()
{
  decl mY;
  
  mY= armagen(zeros(1000, 1), rann(1000, 1), .8, 1, 0)'|
      armagen(zeros(1000, 1), rann(1000, 1), .2~.6, 1, 1)';

  // Display the autocorrelation function of both series
  DrawAcf(0, mY, {"y1", "y2"}, 40, TRUE, FALSE, TRUE, 2, TRUE, TRUE);
  // Display the partial autocorrelation function of both series
  DrawAcf(1, mY, {"y1", "y2"}, 40, FALSE, TRUE, TRUE, 2, TRUE, TRUE);
  // Put one title above both windows together
  DrawTitle(-1, "ACFs and PACFs");
  // Display the two areas next to eachother
  DrawAdjust(ADJ_AREAMATRIX, 1, 2);
  SaveDrawWindow("graphs/drawacf.png");
  ShowDrawWindow();
}
