/*
**  DrawBiv
**
**  Purpose:
**    Some elaborate bivariate graphs
**
**  Date:
**    18/7/2000
**
**  Author:
**    Charles Bos
*/
#include <oxstd.h>      // Include the Ox standard library header
#include <packages/oxutils/oxutils.h>
#include <packages/gnudraw/gnudraw.h>
#include <oxprob.h>

main()
{
  decl mY, iK, vMMX, vStep, mX, mXX, mZ, vX, vY;

  mY= ranchi(1, 1000, 10)|
      ranchi(1, 1000, 4);

  DrawTitle(0, "Sampled Chi-2(10) vs Chi-2(4)");
  [vX, vY, mZ]= DrawBivDensity(0, mY, "", TRUE, FALSE, FALSE);

  DrawTitle(1, "Contours of sampled Chi-2(10) vs Chi-2(4)");
  DrawXYZ(1, vX, vY, mZ, 2);

  iK= 20;
  vMMX= limits(mY')[:1][]';
  vStep= (vMMX[][1] - vMMX[][0])/(iK-1);
  mX= range(0, iK-1) .* vStep + vMMX[][0];
  mXX= (mX[0][] ** ones(1, iK)) |
       (ones(1, iK) ** mX[1][]);
  mZ= denschi(mX[0][], 10) .* denschi(mX[1][]', 2);

  DrawTitle(2, "Analytical Chi-2(10) vs Chi-2(4)");
  DrawXYZ(2, mX[0][], mX[1][], mZ, 0, "Chi-2(10)", "Chi-2(4)", "");

  DrawTitle(3, "Density/histogram plot of Chi-2(10)");
  DrawDensity(3, mY[0][], "Chi-2(10)", TRUE, TRUE, TRUE);

  SaveDrawWindow("graphs/drawbiv.png");
  ShowDrawWindow();
}
