/*
**  DrawBiv_ox
**
**  Purpose:
**    Show bivariate graphs using OxDraw, based on bivdensest.ox
**
**  Date:
**    28/2/2012
**
**  Author:
**    Charles Bos
*/
#include <oxstd.h>      // Include the Ox standard library header
#include <oxdraw.h>
#include <oxprob.h>
#import <lib/densest>


/*  
**  DrawBivDensity(const iArea, const mY, const asY, const fDens,
**                 const fHist, const fNormal, const iMode);
**
**      iArea 
**          in: int, area index 
**      mY 
**          in: k x T matrix, each row is a new plot 
**      asY 
**          in: string, variable name, or array of strings (k > 1) 
**      fDens 
**          in: int, TRUE: draw estimated density 
**      fHist 
**          in: int, TRUE: draw histogram (not implemented here)
**      fNormal 
**          in: int, TRUE: add normal density for reference (not
**          implemented here)
**      iMode (optional)
**          in: int, type of plot: 
**          0 - surface plot only
**          1 - surface plot with contours on ground level
**          2 - contour plot
**  
**  Return value:
**      none
**  
**  Draws the bivariate density of the data in the 
**  specified area using OxDraw. 
*/
DrawBivDensity(const iArea, const mY, const asY, const fDens,
               const fHist, const fNormal, ...)
{
  decl iAreaL, iK, i, j, mXY, mZ, ava, iMode;
  
  iAreaL= iArea;
  ava= va_arglist();
  iMode= sizeof(ava) ? ava[0] : 0;
  iK= rows(mY);
  
  if (!fDens || fHist || fNormal)
    oxwarning ("Only density plot implemented");
  
  for (i= 0; i < iK; ++i)
    for (j= i+1; j < iK; ++j)
      {
        [mXY, mZ]= BivDensEst(mY[i~j][]', 0, 0,  0, 0);	  	// Gaussian

        DrawXYZ(iAreaL, mXY[0][], mXY[1][], mZ', iMode, 
          i < sizeof(asY) ? asY[i] : "", j < sizeof(asY) ? asY[j] : "", 
          "", 2, 1);
      }
}

main()
{
  decl mY, iK, vMMX, vStep, mX, mXX, mZ, vX, vY;

  mY= ranchi(1, 1000, 10)|
      ranchi(1, 1000, 4);

  DrawTitle(0, "Sampled Chi-2(10) vs Chi-2(4)");
  DrawBivDensity(0, mY, "", TRUE, FALSE, FALSE);
  SaveDrawWindow("graphs/drawbiv_ox.eps");
  ShowDrawWindow();
}
