/*
**  DrawDensIS
**
**  Purpose:
**    Provide an example of using the DrawDensity routine with the
**    importance sampler weights
**
**  Date:
**    7/5/2001
**
**  Author:
**    Charles Bos
*/
#include <oxstd.h>      // Include the Ox standard library header
#include <packages/gnudraw/gnudraw.h>

main()
{
  decl vU, vW, vN;

  // Sample random uniform from [-3, 3]
  vU = ranu(1, 1000)*6 - 3;
  // Calculate the weights according to the normal density
  vW= densn(vU);

  // Draw the density of the uniform random values, with weights
  // according to the normal density
  DrawDensity(0, vU, "Uniform-Normal", TRUE, TRUE, TRUE, FALSE, FALSE,
              -1, 2, vW);
  DrawTitle(0, "With weights");
  // Draw the density of the uniform random values, without weights
  DrawDensity(1, vU, "Uniform", TRUE, TRUE, TRUE);
  DrawTitle(1, "Without weights");
  SaveDrawWindow("graphs/drawdensis.png");
  ShowDrawWindow();
}
