/*
**  DrawFan
**
**  Purpose:
**    Draw a fan plot
**
**  Date:
**    21/3/2003
**
**  Author:
**    Charles Bos
*/
#include <oxstd.h>      // Include the Ox standard library header
#include <oxprob.h>
#include <packages/gnudraw/gnudraw.h>

main()
{
  decl mY, iN, iK, vMu, vS;
  
  iN= 5;
  iK= 10;
  mY= rant(iN, iK, 4);
  vMu= meanc(mY);
  vS= sqrt(varc(mY));

  Draw(0, vMu);
  DrawZ(vS, "FAN", ZMODE_FAN);
  DrawTitle(0, "Fan plot, using default call");

  Draw(1, vMu);
  DrawZ(quann(range(.05, .95, .05)').*vS[0][], "FAN2", ZMODE_FAN, range(.05, .95, .05));
  DrawTitle(1, "Fan plot, specifying quantiles");
  ShowDrawWindow();  

  Draw(0, vMu);
  DrawZ(vS, "FAN", ZMODE_FAN);

  mY= rant(iN, iK, 4);
  vMu= meanc(mY);
  vS= sqrt(varc(mY));

  DrawMatrix(0, vMu, "", iK-3, 1, 0, 3);
  DrawZ(vS, "FAN", ZMODE_FAN);
  
  DrawMatrix(0, rann(1, iK+5)+3, "", 1, 1, 0, 4);
  
  DrawTitle(0, "Dual fan plot with line");
  SaveDrawWindow("graphs/drawfan.plb");
  ShowDrawWindow();
}
