/*
**  DrawZ
**
**  Purpose:
**    Test DrawZ, version OxDraw
**
**  Date:
**    1/3/2002
**
**  Author:
**    Charles Bos
*/
#include <oxstd.h>      // Include the Ox standard library header
#include <oxprob.h>
#include <packages/gnudraw/gnudraw.h>

main()
{
  decl mY, iN, iK, i, vMu, vS;
  
  iN= 5;
  iK= 10;
  mY= rant(iN, iK, 4);
  vMu= meanc(mY);
  vS= sqrt(varc(mY));
  mY= <>;

  Draw(0, vMu);
  DrawZ(vS, "Bar", ZMODE_BAR, 2, 3);

  Draw(1, vMu);
  DrawZ(vS, "Band", ZMODE_BAND, 2, 3);
  
  Draw(2, vMu);
  DrawZ(vS, "FAN", ZMODE_FAN, 2, 3);

  Draw(3, vMu);
  DrawZ(vS, "HILO", ZMODE_HILO, 1, 3);

  Draw(4, vMu);
  DrawZ(range(1, 10), "Value", ZMODE_VALUE, 1, 3);

  SaveDrawWindow("graphs/drawz.eps");
  ShowDrawWindow();  

  Draw(0, vMu);
  DrawZ(vS, "3D", ZMODE_3D, 2, 3);
  SaveDrawWindow("graphs/drawz3d.eps");
  ShowDrawWindow();  
}
