/*
**
**  Example.ox
**
**  Purpose:
**    Provide an example for using GnuPlot together with LaTeX
**
**  Date:
**    19/7/2000
**
**  Author:
**    Charles Bos
**
*/
#include <oxstd.h>      // Include the Ox standard library header
#include <packages/gnudraw/gnudraw.h>

main()
{
  decl mY;

  mY= rann(1, 1000);
  // Preparing LaTeX output
  DrawDensity(0, mY, "$\\theta$", 1, 1, 1);
  SaveDrawWindow("graphs/examtex.tex");
  SaveDrawWindow("graphs/exametex.etex");
  CloseDrawWindow();

  // Preparing EPS output
  DrawDensity(0, mY, "{/Symbol q}", 1, 1, 1);
  SaveDrawWindow("graphs/exameps.eps");
  SaveDrawWindow("graphs/exampdf.pdf");
  SaveDrawWindow("graphs/exameps.plb");
  CloseDrawWindow();

  DrawDensity(0, mY, "theta", 1, 1, 1);
  SaveDrawWindow("graphs/exampng.png");
  SaveDrawWindow("graphs/examfig.plb");
  ShowDrawWindow();
}
