/*
**  Fill
**
**  Purpose:
**    Depict the various ways in which a graph can be filled in using
**    GnuDraw/GnuPlot
**
**  Author:
**    Charles Bos
**
**  Date:
**    29/6/2005
*/
#include <oxstd.h>
#include <packages/gnudraw/gnudraw.h>

main()
{
  decl vX, vY, vSel;
  
  vX= range(-3, 3, .05);
  vY= densn(vX);
  
  vSel= vecrindex(vX .> quann(.95));

  // Use a set of boxes, choosing the fill-style  
  DrawXMatrix(0, vY, "y", vX, "x", 0, 2);
  DrawXMatrix(0, vY[vSel], "boxes", vX[vSel], "", 0, 2);
  DrawAdjust(ADJ_COLOR, 3, TP_USER, "boxes fs pattern 1");
  
  // Fill the region within the curve; make sure that it is 'closed'
  DrawXMatrix(1, vY, "y", vX, "x", 0, 2);
  DrawXMatrix(1, 0~vY[vSel]~0, "filledcurves, closed region", min(vX[vSel])~vX[vSel]~max(vX[vSel]), "", 0, 3);
  DrawAdjust(ADJ_FILLCURVE);

  // Fill the region between the curve and the x-axis
  DrawXMatrix(2, vY, "y", vX, "x", 0, 2);
  DrawXMatrix(2, vY[vSel], "filledcurves to x-axis", vX[vSel], "", 0, 3);
  DrawAdjust(ADJ_FILLCURVE, 1);
  
  // Just redraw the region using impulses  
  DrawXMatrix(3, vY, "y", vX, "x", 0, 2);
  DrawXMatrix(3, vY[vSel], "impulses", vX[vSel], "", 3, 3);
  
  SaveDrawWindow("graphs/fill.png");
  ShowDrawWindow();
}
