/*
**  Fonts
**
**  Purpose:
**    Display larger fonts
**
**  Date:
**    2/1/08
**
**  Author:
**    Charles Bos
*/
#include <oxstd.h>
#include <packages/gnudraw/gnudraw.h>

main()
{
  // Set one font-size by hand; standard font-size is around 10-14
  DrawMatrix(0, rann(3, 10), {"aaa", "{/=30 bbb}", "ccc"}, 1, 1);

  // Double the legend size
  DrawAdjust(ADJ_LEGEND, 0, 1, 600, 0, 0);
  
  // Draw some labels
  DrawText(0, "Small, font 1", 3, 1, 1, 150);
  DrawText(0, "Large, font 2", 4, 0, 2, 600);
  DrawText(0, "Normal, font 3", 5, -1, 3, 300);
  
  // Adjust the labels on the axes, 30 degrees rotated, font 2, half size
  //   font and double size tic-marks
  DrawAdjust(ADJ_AXISLABEL, 30, 2, 150, 2);

  // Adjust globally all fonts, to type 0 double size
  SetDraw(SET_FONT, 0, 600);

  SaveDrawWindow("graphs/fonts.plb");

  SaveDrawWindow("graphs/fonts.eps");
  SaveDrawWindow("graphs/fonts.png");
  SaveDrawWindow("graphs/fonts.pdf");
  SaveDrawWindow("graphs/fonts.svg");
  ShowDrawWindow();
}
