/*
**  Intradaily
**
**  Purpose:
**    Show the possibility to plot irregular dates, including intradaily
**
**  Date:
**    31/8/2005
**
**  Author:
**    Charles Bos
*/
#include <oxstd.h>      // Include the Ox standard library header
#include <oxprob.h>
#include <oxfloat.h>
#include <packages/gnudraw/gnudraw.h>

main()
{
  decl mY, mYMD, mHMS;

  mY= ranchi(3, 4, 10);
  mYMD= <1987, 1987, 1987, 1987; 
            3,    3,    3,    3; 
            1,    1,    2,    2>;
  mHMS= <19, 23,  6, 9;
         10,  5, 35, 51;
         15,  1, 59, 6>;         

  DrawAbout();
  DrawTitle(-1, "Intradaily data");
  DrawTMatrix(0, mY, "Specifying hourly data", 
              mYMD|mHMS[0][]|zeros(2, columns(mYMD)), "'%Hh'", 0, 2);

  DrawTMatrix(1, mY, "Intradaily", 
              mYMD|mHMS, "\"%d/%m\\n%Hh\"", 0, 2);
              
  // Regular intradaily data is possible specifying 
  //   the negative of the hour as the first element,
  //   the number of minutes after the hour for the period
  //   and the number of observations per hour for the frequency              
  DrawTMatrix(2, ranchi(1, 79, 10), "5-minute data 9:30-16:00h",
              -9, 30, 12);
  DrawAdjust(ADJ_AXISFORMAT, " %H:%M", TRUE);
 SaveDrawWindow("graphs/intradaily.plb");
  ShowDrawWindow();
}
