/*
**  NBER
**
**  Purpose:
**    Check how NBER data could be plotted
**
**  Author:
**    Charles Bos/James Davidson
**
**  Date:
**    24/4/07
*/
#include <oxstd.h>
#include <oxfloat.h>
#include <arma.h>
#include <packages/gnudraw/gnudraw.h>

main()
{
  decl iT, vTime, vY, vNBER, vSel, iMin, iMax, i;
  
  iT= 50;
  vTime= range(0, iT) + dayofcalendar(2007, 1, 1);
  vY= armagen(zeros(iT, 1), rann(iT, 1), .95, 1, 0)';
  
  iMin= floor(min(vY));
  iMax= ceil(max(vY));
  
  vNBER = vY .> 0;

  // Shade regions where NBER is 1; use closed curves.
  //   Shade between max(vY) and min(vY)
  DrawTMatrix(0, vNBER .? iMax .: M_NAN, "", vTime, 0, 0, 0, 5);
  DrawAdjust(ADJ_FILLCURVE, 0, iMin);
  // Plot y-series afterwards, on top of the filled curve
  DrawTMatrix(0, vY, "y", vTime, 0, 0);

  //   Shade between vY and x-axis
  DrawTMatrix(1, vNBER .? vY .: M_NAN, "", vTime, 0, 0, 0, 5);
  DrawAdjust(ADJ_FILLCURVE, 1);
  // Plot y-series afterwards, on top of the filled curve
  DrawTMatrix(1, vY, "y", vTime, 0, 0);

  SaveDrawWindow("graphs/nber.png");
  ShowDrawWindow();
}
