/*
**  Time series
**
**  Purpose:
**    Depict the way a daily time series plot can be made using
**    GnuDraw/GnuPlot
**
**  Author:
**    Charles Bos
**
**  Date:
**    7/7/2005
**    1/9/2005  Adapted for reordering the dates
*/
#include <oxstd.h>
#include <oxfloat.h>
#include <packages/gnudraw/gnudraw.h>

main()
{
  decl vY, vDate, iT;
  
  // Create a series of days 1989/1/1-2003/12/31
  vDate= range(dayofcalendar(1989, 1, 1), dayofcalendar(2003, 12, 1));
  iT= sizerc(vDate);
  vY= rann(1, iT);
  
  // Draw daily time series using dayofcalendar
  DrawTMatrix(0, vY, "y", vDate, 0, 0);
  DrawTitle(0, "Daily time series");
  
  // Same plot, different axis, but only until January 2003
  DrawTMatrix(1, vY, "y", vDate, 0, 0);
  DrawAdjust(ADJ_AREA_X, 1, M_NAN, dayofcalendar(2003, 1, 1));
  DrawAdjust(ADJ_AXISFORMAT, " %m/%y", TRUE);
  DrawTitle(1, "Daily time series, limited axis, labelling");

  // Monthly series
  iT= 12*15;
  DrawTMatrix(2, vY[:iT-1], "y", 1989, 1, 12);
  // Adjust area X specifying fully including day
  DrawAdjust(ADJ_AREA_X, 1, dayofcalendar(1989, 1, 1), dayofcalendar(2003, 1, 1));
  DrawTitle(2, "Monthly time series, limited axis");

  // Daily series, doing it the Ox way
  DrawXMatrix(3, vY, "y", vDate, "");
  DrawAdjust(ADJ_AXISSCALE, AXIS_DATE);
  // Adjust area X specifying vDate
  DrawAdjust(ADJ_AREA_X, 3, M_NAN, dayofcalendar(1995, 1, 1));
  DrawTitle(3, "Daily time series, limited axis");

  // Quarterly series, doing it the Ox way
  DrawTMatrix(4, vY[:iT-1], "y", 1989, 1, 4);
  DrawTitle(4, "Quarterly time series, limited axis");

  // Daily series, doing it the Ox way
  DrawXMatrix(5, vY, "y", vDate, "");
  DrawAdjust(ADJ_AXISSCALE, AXIS_DATE);
  // Adjust area X specifying vDate
  DrawAdjust(ADJ_AREA_X, 5, M_NAN, dayofcalendar(1995, 1, 1));
  // Choose 1 large tick per year, every quarter year a small tick
  DrawAxis(5, 1, M_NAN, M_NAN, M_NAN, M_NAN, 1, .25, 1);
  DrawTitle(5, "Daily time series, adjusting tics");

  SaveDrawWindow("graphs/timeseries.png");
  ShowDrawWindow();
}
