/*
**  PenTable
**
**  Purpose:
**    Print a table with the test statistics of Pena
**
**  Date:
**    10/12/03
**
**  Author:
**    Charles Bos
*/
#include <oxstd.h>
#include <packages/gnudraw/gnudraw.h>
#include <packages/oxutils/oxutils.h>

const decl cBIC= 6, cF= 0, cBDS= 3, cQ= 4;
main()
{
  decl vSel, vMod, i, iMod, iT, iR, mRes, mOut, asrLab, ascLab,
       sOutbase, bJoin, bRestr, vRestr;
  
  iMod= iT= -1;
  iR= 100;
  
  vMod= range(0, 11);
  
  println ("PenTable\nOptions: model, t, r, join, restr, nogr");

  ReadArg(&vMod, "model", 1);
  ReadArg(&iT, "t", 1);
  ReadArg(&iR, "r", 1);
  ReadArg(&bJoin, "join", 0);
  ReadArg(&bRestr, "restr", 0);
  if (ReadArg(&i, "nogr", 0))
    DrawAdjust(ADJ_SHOW, FALSE);
  
  vRestr= bRestr ? <0, 3, 4, 6, 9, 10, 11> : range(0, 11);
  asrLab= new array [12];
  mOut= <>;
//   vMod= <10, 11>;
//   vMod= range(1, 9);
  
  for (i= 0; i < sizerc(vMod); ++i)
    {
      iMod= vMod[i];
      sOutbase= sprint("excl/ptm", iMod, "t", iT, "r", iR);
      mRes= loadmat(sOutbase~"res.fmt");
      // Tree: If BIC accepts linearity, use F/BDS, else use Q
      //   BIC=1 -> linearity, 0-> nonlin
      mRes|= mRes[cBIC][] .== 0 .? mRes[cQ][] .: mRes[cF][];
      mRes|= mRes[cBIC][] .== 0 .? mRes[cQ][] .: mRes[cBDS][];
      mRes|= minc(mRes[cF~cBDS~cQ][]); // Joint test, minimal p-val of F, BDS, Q
      
      mOut|= meanr(mRes .< .05)';
      asrLab[iMod]= sprint("M", iMod);
      
      DrawBivDensity(0+3*bJoin*i, mRes[cF~cQ][], {"F_{Tsay}", "Q_{ML}"}, 1, 0, 0, 2);
      
      DrawDensity(1+3*bJoin*i, mRes[cF~cQ][], {"F_{Tsay}", "Q_{ML}"}, 1, 0, 0, 0, 0, 10);
      DrawDensity(1+3*bJoin*i, selectifc(mRes[cF~cQ][], mRes[cBIC][] .== 0), {"F_{Tsay} x H_1", "Q_{ML} x H_1"}, 1, 0, 0, 0, 0, 10, 3);
      DrawDensity(1+3*bJoin*i, selectifc(mRes[cF~cQ][], mRes[cBIC][] .== 1), {"F_{Tsay} x H_0", "Q_{ML} x H_0"}, 1, 0, 0, 0, 0, 10, 4);
      
      DrawAdjust(ADJ_AREA_X, 0, 1);
      DrawTitle(1+3*bJoin*i, "");
      DrawAdjust(ADJ_AREA_X, 0, 1);
      
      if (!bJoin)
        {  
          DrawAdjust(ADJ_AREAMATRIX, 1, 3);  
          SaveDrawWindow(sOutbase~"test.eps", 10, 1, .4);
          ShowDrawWindow();  
        }  
    }

  if (bJoin)
    {  
      DrawAdjust(ADJ_AREAMATRIX, sizerc(vMod), 3);  
      SaveDrawWindow(sprint("excl/ptmj", sizerc(vMod), "t", iT, "r", iR, "test.plb"));
      ShowDrawWindow();  
    }  
  ascLab= {"FTsay", "BDS2", "BDS3", "BDS4", "Qml", "AIC", "BIC",
            "AICc", "HQ", "TreeF", "TreeB", "J_FBQ"};           
            
  mRes= (mOut[][9] .>= mOut[][cF~cQ])~
        (mOut[][10] .>= mOut[][cBDS~cQ]);
//   print (mRes~mOut[][cF~cQ~9]);
  
  mOut= mOut[][vRestr];            
  print("%cf", {"%6.3f"}, "%r", asrLab[vMod], "%c", ascLab[vRestr]~"max", mOut~maxc(mOut')');
  print("%cf", {"%6.3f"}, "%r", asrLab[vMod], "%c", ascLab[vRestr], mOut .== maxc(mOut')');

  printtex("%cf", {"%6.3f"}, "%r", asrLab[vMod], "%c", ascLab[vRestr], mOut~mRes);
}
