/*
**  EstSA0
**
**  Purpose:
**    Estimate an ARFIMA model, for comparison with TSMod
**
**  Date:
**    18/9/2003
**
**  Author:
**    Charles Bos
*/
#include <oxstd.h>      // Include the Ox standard library header
#include <oxdraw.h>
//#include <packages/gnudraw/gnudraw.h>
#import <packages/arfima/arfima>

main()
{
  decl db, i, vP, vE, dS, vAdj, vY, mX;
  
  db= new Arfima();
  db.LoadIn7("data/sa0.in7");
  db.Deterministic(FALSE);
  
  db.ARMA(12, 0);
  for (i= 2; i < 12; ++i)
    db.FixPar(i, 0);
  db.SetSelSample(-1, -1, -1, -1);
  db.SetMethod(M_MAXLIK);
  MaxControl(-1, 20, 1);         // print each 20th iteration

  db.Select(Y_VAR, { "ddLPs", 0, 0 } );
  db.Estimate();

  db.DeSelect();
  db.Select(Y_VAR, { "dLPs", 0, 0 } );
  db.Estimate();
  
  db.DeSelect();
  db.Select(Y_VAR, { "dLPs", 0, 0 } );
  db.Select(X_VAR, { "b7307",0,0, "b7607",0,0,
                     "b7901",0,0, "b8207" ,0,0} );
  db.Estimate();

  vP= db.GetFreePar();
  vE= db.GetStdErr();

  mX= db.GetGroup(X_VAR);
  vY= db.GetGroup(Y_VAR);
  vAdj= mX * vP[3:];

  DrawTMatrix(0, vY', "Y", 1958, 1, 12);
  DrawTMatrix(0, vAdj', "break", 1958, 1, 12, 0, 3);
  ShowDrawWindow();
  
  dS= double(sqrt(varc(vY-vAdj)));
  println ("Estimated underlying process variance and standard deviation\n",
           "(after adjusting for breaks):\n",
           "S2Z:    ", sqr(dS), "  sqrt(S2Z):     ", dS);
  println ("Breaksizes and sDev's according to definition in article\n",
           "(relative to variance of underlying, break-adjusted data)",
           "%r", db.GetFreeParNames()[3:],
           (vP[3:]~db.MapParToFree(db.GetStdErr())[3:]) ./ dS);

}
