/*
**  LoadSA0
**
**  Purpose:
**    Prepare the dataset on inflation figures for Ox estimation
**
**  Date:
**    25/5/08       (cleaned out)
**
**  Author:
**    Charles Bos
*/
#include <oxstd.h>      // Include the Ox standard library header
#import <database>

main()
{
  decl vDay, mMY, mY, mX, vB, iT, db;
  
  mY= loadmat("data/sa0.mat", 1);
  mY= mY[12:][];
  mY~= 100*diff0(log(mY), 1);
  iT= rows(mY);
  mMY= ones(ceil(iT/12), 1)**range(1, 12)';
  mMY~= 1958+range(0, ceil(iT/12)-1)'**ones(12, 1);
  
  mMY= mMY[:iT-1][];
  vDay= dayofcalendar(mMY[][1], mMY[][0], ones(iT, 1));
  
  mX= ones(ceil(iT/12), 1) ** unit(12, 12);
  mX= mX[:iT-1][];
  olsc(mY[][1], mX, &vB);
  mY~= mY[][1] - mX*vB;

  db= new Database();
  db.Create(12, mMY[0][1], mMY[0][0], mMY[iT-1][1], mMY[iT-1][0]);
  db.Append(mY[][0], "P");
  db.Append(log(mY[][0]), "LP");
  db.Append(mY[][1], "dLP");
  db.Append(mY[][2], "dLPs");
  db.Append(diff0(mY[][2], 1), "ddLPs");
  
  db.Append(((mMY[][0] .>= 7) .&& (mMY[][1] .== 1973)) .|| (mMY[][1] .> 1973), "b7307");
  db.Append(((mMY[][0] .>= 7) .&& (mMY[][1] .== 1976)) .|| (mMY[][1] .> 1976), "b7607");
  db.Append(((mMY[][0] .>= 1) .&& (mMY[][1] .== 1979)) .|| (mMY[][1] .> 1979), "b7901");
  db.Append(((mMY[][0] .>= 7) .&& (mMY[][1] .== 1982)) .|| (mMY[][1] .> 1982), "b8207");

  db.Info();
  db.SaveIn7("data/sa0.in7");
  delete db;
}
