/*
**  LoadEck
**
**  Purpose:
**    Load the ecker data
**
**  Date:
**    22/9/03
**
**  Author:
**    Charles Bos
*/
#include <oxstd.h>      // Include the Ox standard library header
#include <oxdraw.h>
//#include <packages/gnudraw/gnudraw.h>
#import "packages/maxsa/maxsa"
#include "include/incmax.ox"
#import <database>

static decl s_mX, s_mLU;

UserFunction(const mcX, const cStart, const cEnd, const vP, const sName)
{
  decl vE, iX, iY;

//   iX= VarNum("X");
//   iY= VarNum("Y");
  iX= 1;
  iY= 0;
  
  vE= mcX[][iY] - (vP[0]/vP[1]) * exp(-0.5*sqr((mcX[][iX]-vP[2])/vP[1]));
  
  return vE[cStart:cEnd];  
}

EckerLL(const vP, const adFunc, const avScore, const amHessian)
{
  adFunc[0]= -sqrt(sumsqrc(UserFunction(s_mX, 0, rows(s_mX)-1, vP,
                  "Ecker"))/rows(s_mX));
  
  return !isnan(adFunc[0]) && (vP > s_mLU[][0]) && (vP < s_mLU[][1]);
}

main()
{
  decl mY, vP, iT, db, vS, mS2, dLnPdf, ir, dT, vE;
  
  s_mX= mY= loadmat("data/ecker.mat");
  iT= rows(mY);

  // Save the data in a format for TSMod
  db= new Database();
  db.Create(1, 1, 1, iT, 1);
  db.Append(mY, {"Y", "X"});
  db.Info();
  db.SaveIn7("data/ecker.in7");
  delete db;  

  MaxSAControl(1e6, 2);
  MaxSAControlStep(5, 10, .85, <1; 1; 1>, 2);
  
  vP= <1; 10; 500>;
  s_mLU= <0, 10;
          0, 50;
          300, 1000>;
// Results not found when starting with wider bounds...          
//   s_mLU= <0, 1e6;
//           0, 1e6;
//           0, 1e6>;
  dT= 5;
  ir= MaxSA(EckerLL, &vP, &dLnPdf, &dT);
  MaxStdErr(EckerLL, vP, rows(mY), &vS, &mS2);
  
  print ("%c", {"Par", "sd"}, "%cf", {"%20.15g"}, vP~vS);  
  print ("Res sd: ", "%20.15g", dLnPdf);
  println ("Estimation returns ", MaxSAConvergenceMsg(ir));
  
//  vP= <1; 10; 500>;
  ir= MaxBFGS(EckerLL, &vP, &dLnPdf, 0, 1);
  MaxStdErr(EckerLL, vP, rows(mY), &vS, &mS2);
  
  print ("%c", {"Par", "sd"}, "%cf", {"%20.15g"}, vP~vS);  
  print ("Res sd: ", "%20.15g", dLnPdf);
  println ("Estimation returns ", MaxConvergenceMsg(ir));

  vE= UserFunction(s_mX, 0, rows(s_mX)-1, vP, "Ecker");
  DrawXMatrix(0, mY[][0]', {"Y"}, mY[][1]', "X");
  DrawXMatrix(0, (mY[][0] - vE)', {"yHat"}, mY[][1]', "X", 1, 3);
  DrawAdjust(ADJ_COLOR, 3, 3, 1);
  DrawXMatrix(1, vE', {"E"}, mY[][1]', "X", 1, 3);
  ShowDrawWindow();
}
