/*
**  LoadFil
**
**  Purpose:
**    Load the filip data
**
**  Date:
**    22/9/03
**
**  Author:
**    Charles Bos
*/
#include <oxstd.h>      // Include the Ox standard library header
#include <oxdraw.h>
//#include <packages/gnudraw/gnudraw.h>
#import <database>

main()
{
  decl mY, mYH, mX, vB, iT, iK, i, db, dS, vE, vS, mXtXInv, ir;
  
  mY= loadmat("data/filip.mat");
  iT= rows(mY);
  mX= ones(iT, 1)~mY[][1];
  mY= mY[][0];
  
  db= new Database();
  db.Create(1, 1, 1, iT, 1);
  db.Append(mY, "Y");
  db.Append(mX[][0], "X0");
  db.Append(mX[][1], "X1");

  for (i= 2; i <= 10; ++i)
    {
      mX~= mX[][1].^i;
      db.Append(mX[][i], sprint("X", i));
    }  
  db.Info();
  db.SaveIn7("data/filip.in7");
  db.SaveXls("data/filip.xls");
  delete db;

  iK= columns(mX);  
  ir= olsc(mY, mX, &vB, &mXtXInv);
  mYH= mX*vB;
  vE= mY-mYH;
  dS= sqrt(sumsqrc(vE)./(iT-iK));
  vS= dS*sqrt(diagonal(mXtXInv)');
  print ("%c", {"Par", "sd"}, "%cf", {"%20.15g"}, vB~vS);  
  print ("Res sd: ", "%20.15g", dS);
  println ("Estimation returns ", ir);
  
  DrawXMatrix(0, mY', "Y", mX[][1]', "", 1, 2);
  mYH~= mX[][1];
  mYH= sortbyc(mYH, 1);
  DrawXMatrix(0, mYH[][0]', "Y", mYH[][1]', "", 0, 3);
  ShowDrawWindow();
}
