/*
**  SsfSSFSV
**
**  Purpose:
**    Provide a shell around the SsfPack routines
**
**  Date:
**    25/2/2002
**
**  Author:
**    Charles Bos
*/
#ifndef SSVSV_INCLUDED
#define SSVSV_INCLUDED

#include <oxstd.h>
//#include <packages/gnudraw/gnudraw.h>
#include <oxdraw.h>
#include <arma.h>
#include <oxstd.h>
#include <modelbase.h>
#include <packages/ssfpack/ssfpack_ex.h>

enum // Extra components, not included in SsfPack
{
  CMP_REGR=CMP_TOTAL, CMP_INTER, CMP_REGR2, CMP_INTER2, CMP_SV, 
  CMP_GARCH, CMP_ARMA, CMP_TOTAL2
};
enum // Extra filtering method, not included in SsfPack
{
  ST_PREDSV=DS_SIM_ETA+1
};
enum // CMPTYPES
{ // Note: Ordering should following ordering in SendDialog(OP_SETTINGS)
    CT_STO, CT_FIX, CT_NO
};

enum // CMPSTYPES
{ // Note: Ordering should following ordering in SendDialog(OP_SETTINGS)
    CTS_DUM, CTS_TRIG, CTS_FIX, CTS_NO, CTS_HS
};

enum // CMPPOSITIONS
{
    POS_IRREG, POS_LEVEL, POS_SLOPE, POS_SEAS, POS_SV, POS_TOTAL
};

enum // ESTPARTS
{
    EST_COV,  /* standard deviation parameters */
    EST_PER,  /* period for cycle */
    EST_RHO,  /* rho for cycle, ar(1), phi */
    EST_REGR, /* Regression parameters */
    EST_INTER,/* Intervention parameters */
    EST_REGR2, /* Regression parameters, estimated through state augmentation */
    EST_INTER2,/* Intervention parameters, estimated through state augmentation */
    EST_AR,   /* AR parameter in ARMA model */
    EST_MA,   /* MA parameter in ARMA model */
    EST_TOTAL
};

enum // Estimation types (not all implemented yet)
{   // Meaning: (Importance) Maximum likelihood, concentrated ML,
    // initialize parameters, and PAR for setting/restricting
    // parameter values
    ESTM_ML, ESTM_CML, ESTM_INIT,
    ESTM_PAR, ESTM_TOTAL
};

enum  // New group type, for regression variables inflicting irregular,
      //   level, trend, season or variance process
{   Xi_VAR = X_VAR + 1, Xl_VAR, Xt_VAR, Xs_VAR, Xv_VAR
};

// Note: The constants below have been compiled into the ssfsv.oxo file
//   and cannot be changed by the user.

// Translation vector from position to component
const decl MX_POSCMP= <CMP_IRREG, CMP_LEVEL, CMP_SLOPE, CMP_SEAS_TRIG, CMP_SV, -1>;
const decl MX_CYCLE= 3;
const decl MX_STSMDEF= <CMP_LEVEL, .5, 0, 0;       // Default Stsm   
                        CMP_SLOPE, .2, 0, 0;
                        CMP_SEAS_TRIG, .2, 12, 0;
                        CMP_IRREG, 1, 0, 0>;
const decl MX_STDEVDEF= <.5; .2; .2; .5; 1; .5>;
  // Default standard devations, for level, slope, seasonal, cycle and irregular and ar1
const decl MX_SVDEF= <CMP_SV, .2, 0, .9>;
  // Default SV component, with sigma and phi
const decl MX_SVNEAR0= 1e-1;  
  // Limit for values near zero in SV-computations
const decl MX_VARNEAR0= 1e-5;
  // Limit for variances near zero in parameter vector
const decl MX_SVAPPROX= 1e-7;  // 1e-3; // 
  // Convergence criterium for approximating model
const decl MX_ISV_SIGMA= 0.001;
  // Initial variance for SV component in ISV models
const decl MX_SVBIGK= 9999999.99;
  // Adjustment value for loglikelihood in SV
const decl MX_ISEEDSV= 198195252;
  // Initial seed for SV simulation
const decl MX_ASTNAMES=
   {"Lev", "Sl", "tr", "Seas_dum", "Seas_tr", "Seas_hs", "BWCyc", 
    "Cyc_0", "Cyc_1", "Cyc_2", "Cyc_3", "Cyc_4", "Cyc_5", "Cyc_6", "Cyc_7",
    "Cyc_8", "Cyc_9", "Ar1", "Ar2", "Irr", "Regr", "Inter", "Regr-sa", "Inter-sa",
    "SV", "Garch", "ARMA", "Tot2"};
const decl MX_QUANTISWEIGHT= .9;
  // Quantile for IS weight plots    
   
#ifdef GNUDRAW_INCLUDED   
  const decl MX_FIGEXT=".plb";
#else
  const decl MX_FIGEXT=".eps";
#endif
  
/*
**  Class SsfSV
**
**  Purpose:
**    Contain the necessary structure and routines for SsfPack calls
**
**  Structures:
**    A model consists of 4 elements, namely
**      amStsm      Structure of the state space model,
**                  array of size m_cY with matrices mStsm
**                  It also may contain lines indicating the regression
**                  components with
**                    <CMP_REGR, beta, Type, X-Index>
**                  where type= the point of infliction into the state
**                  vector (0= irreg/y, 1= level, 2= slope, 3= sv), 
**                  and X-Index the index of the X-variable concerned.
**                  Likewise, it may contain lines indicating the 
**                  intervention components with
**                    <CMP_INTER, beta, Type, Time>
**                  where Time is the time index when the infliction
**                  hits.
**      mSV         Matrix of size 2 x 1 with SV parameters
**
**  Indices:
**      mPIndex
**      aEstIndex
*/
class SSFSV : Modelbase
{
    static decl m_cModel; // Count of equation number
    static decl m_amStsm,  
      // Model building structure, with elements in mStsm
    m_mRelSeas,
      // Matrix with indications if variances of Trigonometric seasonal
      //   are to be released/fixed. If <>, one seas fits all.
      //   Otherwise, first column indicates if Sj is to be fixed at
      //   the value in the second column.
    m_mPhi, m_mOmega, m_mSigma, m_mDelta, m_mJ_Phi, m_mJ_Omega,
    m_mJ_Delta, m_mYtSsf, m_mXtSsf, m_mYtHRS, m_mTV, m_viSVselect,
      // Ssf components
    m_mPhiSV, m_mOmegaSV, m_mSigmaSV, m_mDeltaSV, m_mJ_PhiSV,
    m_mJ_OmegaSV, m_mJ_DeltaSV,
      // Ssf-SV components
    m_vGarch,
      // Ssf-Garch parameters  
    m_amD, m_amRet, m_vhMeanSV, m_vhFiltSV, m_bMeanSV, m_vhForSV,
    m_mForSV, m_vV, m_vF, m_vSelKF, m_mW, 
      // Ssf filtered and smoothed states, H, an indicator for
      //   computation of H, pred. errors, variances, selection matrix,
      //   weights
    m_iSeedSV, m_iMaxRepSV= 50, m_iSimSV= 250,
      // Saved seed, maximum number of repetitions and number 
      // of simulations for the SV computations
    m_vParOld,
      // Old vector of parameters, checking for change
    m_mInvHess,
      // Inverse Hessian, no longer saved between BFGS optimisations as it 
      //   seems to lead to optimisation troubles
    m_mYHTilde,
      // Matrix used within SV computation      
    m_mPIndex, 
      // Matrix, with one row for each free parameter. Columns indicate
      //   component, estimation element, state index, size of state
      //   element (with regard to elements with variance sigma) and 
      //   dimension in multivariate system, e.g. for the first element
      //   of a BSM:
      //     mPIndex= CMP_LEVEL~EST_COV~iSt~1~j
      //   The size of the state element is e.g. 1 for the irregular
      //   component, m_iFreq-1 for SEAS_TRIG, m_iFreq for SEAS_HS but
      //   only 1 for SEAS_DUMMY, as there only the first element is
      //   truly free, has a non-zero variance.
      //   with iSt= 0, j= 0.
      //   For the regressions, the spot of iSt is taken up by the
      //   index into the time varying matrix mTV, j is
      //   replaced by the index into m_mXt for the explanatory variable.
      //   For the interventions, the spot of iSt is taken up by the
      //   index into the time varying matrix mTV, j is
      //   replaced by the time-index for which the intervention holds.
    m_aEstIndex,
      // For all elements EST_COV, .., the array gives an index to
      //   the parameters concerned
    m_mStIndex,
      // Matrix of size m_cY x CMP_TOTAL gives for all
      //   state components CMP_LEVEL, .., an indication where
      //   in the state the component starts.
    m_vPosCmp,
      // Matrix, with index into correct position of infliction for
      //     POS_IRREG, POS_LEVEL, POS_SLOPE, POS_SEAS, POS_SV, POS_TOTAL
    m_bTransform, m_bX_SA,
      // Boolean, indicating if the parameter vector is in its
      //   transformed state, and if state augmentation is used for
      //   explanatory variables.
    m_bSV, m_bGarch, m_bApprox, 
      //   Integer for the SV-component (0= none, 1= exact, 2=
      //     approximate) and boolean for Garch, boolean indicating
      //     approximation (set through menu)
    m_bBayes, m_mTheta, m_cRep, m_cSkip, m_mPrior, m_dFree,
    m_vMuCand, m_mS2Cand, m_bMLCandInit, m_vScore, m_dQuant,
    m_dTime, m_iZoom1, m_iZoom2,
      // Bayes indicator, result matrix, number of reps, skipped
      //   drawings, prior settings and degrees of freedom of
      //   candidate, score vector, quantiles in confidence bounds,
      //   time, indices for zoom of residual plots
    m_asGenrVar, m_mGenr,
      // Names of variables to be generated, and the data
    m_dVar,
      // Global to pass around variance estimate
    m_asParnames,
      // Parameter names
    m_sGraphbase,
      // String, indicating if and where graphics are saved
    m_iDebug,
      // Debug-level
    m_bPredIter,
      // Boolean, indicates if correct but slower method for
      //   filtering residuals is used
    m_iCntDots;
      // Counter for the number of dots on a line, when debugging.

    // In ssfsv_dialog
    CreateSampleString(iZoom1, iZoom2);
    ReadSampleString(sSample);
    CreateSettingDialog(const mStsm);
    PutSettingValues(const asOptions, const aValues);
    CreateModifyDialog(const mStsm);
    PutModifyValues(const asOptions, const aValues);
    CreateArmaDialog(const mStsm);
    PutArmaValues(const asOptions, const aValues);
    CreateVarianceDialog(const mStsm);
    PutVarianceValues(const asOptions, const aValues);
    CreateInterDialog(const amStsm);
    PutInterValues(const asOptions, const aValues);
    CreateOptionsDialog();
    PutOptionsValues(const asOptions, const aValues);
    CreateParameterDialog();
    PutParameterValues(const asOptions, const aValues);
    CreateTestGraphicsDialog();
    PutTestGraphicsValues(const asOptions, const aValues);
    CreateTestResidualsDialog();
    PutTestResidualsValues(const asOptions, const aValues);
    CreateTestAuxResidualsDialog();
    PutTestAuxResidualsValues(const asOptions, const aValues);
    CreateTestWeightDialog();
    PutTestWeightValues(const asOptions, const aValues);
    
    virtual SendDialog(const sDialog);
    virtual SendMethods();
    virtual SendMenu(const sMenu);
    virtual ReceiveDialog(const sDialog, const asOptions, const aValues);
    
    // In ssfsv_OxInterface
    ChooseModel(const mStsm, ...);
    ChooseSeasTrig(const vFixInd, const vFixVal);
    SaveGraphics(const sGraphbase);
    ChooseSVRep(const iMaxRep, const iSimSV, ...);
    ChooseTransform(const bUseTransform);
    ChoosePredIter(const bPredIter);
    GetISWeights();
    SetSampleZoom(const iZoom1, const iZoom2);

    // In ssfsv_likl
    GetHMean();
    GetHFilt();
    GetH(const iMethod);
    SVMomentEst(const iMethod, const vh, const bSave, const amD);
    SVMomentEstPred(const amD);
    SVMomentEstFut(const amFor, const vhSV, const vhForSV, const iFut);
    SVForecast(const iFut);
    SVApproxModel();
    SSFSVSsfLikSV(const adFunc, const adVar);
//    SSFSVSsfLikSV_Approx(const adFunc, const adVar);
    SSFSVSsfLikGarch(const adFunc, const adVar);
    SSFSVLikelihood(const vP, const adFunc, const avScore, const amHessian);
    SSFSVLikl_HRS(const vP, const adFunc, const avScore, const amHessian);
    GenerateSsf(const vP, asName);

    // In SsfSV_estimate
    TransformPar(const vP);
    TransformBackPar(const vPTrans, const bMirror);
    PutPars(const vP);    
    PutParsHG(const vP);    
    InitEstimation();
    InitEstimationSV();
    Estimate();
    DoEstimation(vP);
    DoEstimationCML(const avP);
    DoEstimationMLSJ(const avP);
    Covar();
    GetResiduals();
    GetResidualsVar();
    GetConfBounds();
    Output();
    OutputPar();
    OutputLogLik();
    GetFinalState(const iMethod, const amDS, const amDP);
    
    // In SsfSV_test
    ExtractStates(const iMethod);
    CheckZoom();
    TestGraphics(vbPlot, const bFilt, const iaLog, const iNLSeas);
    TestResiduals(vbPlot, const iLag, const bWrite);
    TestAuxResiduals(vbSel, vbPlot, const dLimit, const bWrite);
    TestParameterGraphs();
    TestWeightGraphs(const vP, iW);
    TestISWeightGraphs(dQ);
    TestSummary(const bShow);
    TestFinal();
    TestNormality(const vRes, const sName);
    TestGoodFit();
    TestCorrelogram();
    PrintTestVal(const dTest, const cR, const cTdf, const sLabel, 
                 const bPrint);

    // In SsfSV main file
    SSFSV();
    Debug(const iLevel);
    GetPackageName();
    GetPackageVersion();

    static GetModelNumber();
    ClearModel();

    InitIndicesStsm(const amStsm);
    InitStsm(const amStsm, const mPIndex, const mStIndex);
    InitData();
    InitPar();
    SetStartPar(const vParFree);

    virtual GetParNames();
    virtual IsUnivariate();

    // OxPack related
    virtual SendVarStatus();
    virtual SendSpecials();
    virtual ReceiveData();
    virtual ReceiveModel();
};

// Do include it when compiling, don't do the same when importing...
// #include "ssfsv.ox"

#endif
