/*
**  LoadCuur
**
**  Purpose:
**    Read the Inflation data base
**
**  Date:
**    
**
**  Author:
**    Charles Bos
*/
#include <oxstd.h>      // Include the Ox standard library header
#include <include/choosedraw.h>

#import "packages/oxutils/oxutils"
#import <database>

main()
{
  decl mX, mY, mMY, db, iT;
  
  mX= loadmat("data/cuur0000sa0l1e.mat");
  mMY= mX[][<1, 0>]';
  mY= mX[][2]';

  iT= columns(mY);
  db= new Database();
  db.Create(12, mMY[1][0], mMY[0][0], mMY[1][iT-1], mMY[0][iT-1]);
  db.Append(mY', "cuur");
  db.Append(log(mY'), "Lcuur");
  db.Append(100*diff0(log(mY'), 1), "dLcuur");

  db.Info();
  db.SaveIn7("data/cuur0000sa0l1e.in7");

  db.SetSelSample(1957, 1, 2001, 9);
  mY= db.GetVar("cuur");
  mY~= db.GetVar("dLcuur");
  DrawTMatrix(0, mY[][0]', "CPI", 1957, 1, 12);
  DrawTMatrix(1, mY[][1]', "Inflation", 1957, 1, 12);
  DrawAdjust(ADJ_AREAMATRIX, 1, 2);
  #ifdef GNUDRAW_INCLUDED
  SaveDrawWindow("excl/cuur0000sa0l1e.plb", 10, 1, .5);
  #endif
  ShowDrawWindow();
}

