/*
**  acfq(const ma, const vlag)
**
**  Purpose:
**    Compute quickly the acf at prespecified lags
**
**  Inputs:
**    ma      T x n matrix with data
**    vlag    1 x q (or a x b matrix, q=ab) with lags
**
**  Return value
**    q x n matrix with autocorrelations at specified lags.
*/
#ifndef ACFQ_INCLUDED
  #define ACFQ_INCLUDED
#include <arma.h>
acfq(const ma, const vlag)
{
  decl i, iQ, mAcf, mam, vlagL;

  vlagL= unique(vlag);
  iQ= sizerc(vlagL);
  mAcf= new matrix [iQ][columns(ma)];  
  mam = ma - meanc(ma); // in deviation from mean 
  for (i = 0; i < iQ; ++i) 
    mAcf[i][] = sumc(mam .* lag0(mam, vlagL[i])); 
  mAcf = mAcf ./ sumsqrc(mam); // scale by SSR

  return mAcf;
}
#endif
