/*
**  Library LockFile
**
**  Purpose:
**    Create a lockfile, to make sure only one ox-program is working
**    on the same set of results at a time
*/
#ifndef LOCK_INCLUDED
  #define LOCK_INCLUDED
  #include <oxstd.h>

/*
**  lockfile(const sFilebase)
**
**  Purpose:
**    Lock the file
**
**  Input:
**    Basename for the file, excluding extension. The extension
**      '_lock.txt' is added to the filename here
**
**  Return value:
**    TRUE if succeeded, FALSE if the file was already in use
*/
lockfile(const sFilebase)
{
  decl fh, ir;

  ir= FALSE;
  fh= fopen(sFilebase~"_lock.txt", "r");
  if (isfile(fh))
    {
      fh= fclose(fh);
      println("File ", sFilebase, "_lock.txt in use");
    }  
  else
    {  
      fh= fopen(sFilebase~"_lock.txt", "w");
      if (!isfile(fh))
        println("Warning: Cannot create ", sFilebase, "_lock.txt");
      else  
        {
          fh= fclose(fh);
          ir= TRUE;
        }  
    }    
  
  return ir;
} 

/*
**  unlockfile(const sFilebase)
**
**  Purpose:
**    Unlock the file
**
**  Input:
**    Basename for the file, excluding extension. The extension
**      '_lock.txt' is added to the filename here
**
**  Return value:
**    None
*/
unlockfile(const sFilebase)
{
  decl fh, sCommand, i;

  #ifdef OX_Windows
    {
      sCommand= "del "~sFilebase~"_lock.txt";
      i= strfind(sCommand, "/");
      while (i >= 0)
        {
          sCommand[i:i]= "\\";
          i= strfind(sCommand, "/");
        }  
      systemcall (sCommand);
//      println ("Running ", sCommand);
    }  
  #else
    systemcall ("rm "~sFilebase~"_lock.txt");
  #endif  
}
#endif
