/*
**  printtex(const a, ...)
**
**  Purpose:
**    Print output in LaTeX format using the Ox calling sequence.
**
**  Author:
**    Charles Bos
**
**  History:
**    16/04/2004    Based on printmat.ox
*/
#ifndef PRINTTEX_INCLUDED
  #define PRINTTEX_INCLUDED
// Declaration of local procedure
static printtexfmt (const fh, const aPrFmt, const aCLab, const aRLab, const aI);

printtex(const a, ...)
{
  decl va, aI, i, aPrFmt, aCLab, aRLab, bNewLine;
  
  va= {a}~va_arglist();
  
  aPrFmt= {""};
  aCLab= aRLab= {};
  i= 0;
  bNewLine= FALSE;
  while (i < sizeof(va))
    {
      aI= va[i++];
      if (isstring(aI) && (aI == "%r"))
        aRLab= va[i++];  
      else if (isstring(aI) && (aI == "%c"))
        aCLab= va[i++];  
      else if (isstring(aI) && (aI == "%cf"))
        aPrFmt= va[i++];  
      else if (isstring(aI) && (aI == "%C"))
        printtexfmt (0, array(aI), {}, {}, va[i++]);
      else if (ismatrix(aI))
        {
          if (bNewLine)
            print ("\n");
          printtexfmt (0, array(aPrFmt), array(aCLab), array(aRLab), aI);
          aPrFmt= {""};
          aCLab= aRLab= {};
          bNewLine= FALSE;
        }
      else 
        {
          print (aI);        
          bNewLine= TRUE;
        }  
    }
    
  return i;  
}

fprinttex(const fh, const a, ...)
{
  decl va, aI, i, aPrFmt, aCLab, aRLab;
  
  va= {a}~va_arglist();
  
  aPrFmt= {""};
  aCLab= aRLab= {};
  i= 0;
  while (i < sizeof(va))
    {
      aI= va[i++];
      if (isstring(aI) && (aI == "%r"))
        aRLab= va[i++];  
      else if (isstring(aI) && (aI == "%c"))
        aCLab= va[i++];  
      else if (isstring(aI) && (aI == "%cf"))
        aPrFmt= va[i++];  
      else if (isstring(aI) && (aI == "%C"))
        printtexfmt (fh, array(aI), {}, {}, va[i++]);
      else
        {
          printtexfmt (fh, array(aPrFmt), array(aCLab), array(aRLab), aI);
          aPrFmt= {""};
          aCLab= aRLab= {};
        }
    }
    
  return i;  
}


/*
**  printtexfmt (const fh, const aPrFmt, const aCLab, const aRLab, const mX)
**
**  Purpose:
**    Print an item, using specified format and labels
*/
static printtexfmt (const fh, const aPrFmt, const aCLab, const aRLab, const mX)
{
  decl i, j, k, nC, nR, nF, iwL, srFmt, sPrFmt, sLine;

  if (isarray(mX))
    for (j= 0; j < sizeof(mX); ++j)
      printtexfmt(fh, aPrFmt, aCLab, aRLab, mX[j]);
  else if (isstring(mX))
    if (isfile(fh))
      fprintln (fh, "%cf", aPrFmt, mX~" \\\\");
    else
      println ("%cf", aPrFmt, mX~" \\\\");
  else 
    {
      // get sizes
      nC= sizec(mX);
      nR= sizer(mX);
      nF= sizeof(aPrFmt);

      // fix width of row label
      iwL= 1;
      for (i= 0; i < min(nR, sizeof(aRLab)); ++i)
        iwL= max(iwL, sizeof(aRLab[i]));
      srFmt= sprint("%", iwL, "s");

      // column headers
      if (sizeof(aCLab))
        {
          sLine= sprint(srFmt, " ");
          for (i= 0; i < min(sizeof(aCLab), nC); ++i)
            sLine~=sprint(" & ", aCLab[i]);
          sLine ~= " \\\\";
          if (isfile(fh))
            fprintln (fh, sLine);
          else
            println (sLine);
        }  

      // matrix elements
      for (i= 0; i < nR; ++i)
        {
          sLine= sprint(srFmt, (i < sizeof(aRLab)) ? aRLab[i] : " ");

          for (j= 0; j < nC; ++j)
            if (isnan(mX[i][j]))
              sLine~=" & ";
            else
              {  
//              sLine~= sprint(" & ", aPrFmt[imod(j, nF)], mX[i][j]);
                sPrFmt= aPrFmt[min(j, nF-1)];
                k= strfind(sPrFmt, "%");
                sLine~= sprint(" & ", k > 0 ? sPrFmt[:k-1] : "",
                               k >= 0 ? sPrFmt[k:] : "", mX[i][j]);
              }                               
                
          sLine ~= " \\\\";
          if (isfile(fh))
            fprintln (fh, sLine);
          else
            println (sLine);
        }
    }   
}
#endif
