/*
**  ReadArg
**
**  Purpose:
**    Read command line arguments
**
**  Inputs:
**    sX        String with indicator for command line argument
**    bBool     Boolean, indicating if the variable is boolean; if
**              negative variable is a string
**
**  Output:
**    aiX       Pointer to output variable, with value on command line
**              if the string indicator is found, or unchanged otherwise.
**              Boolean values default to FALSE, if the argument is not
**              found.
*/
#ifndef READARG_INCLUDED
  #define READARG_INCLUDED
ReadArg(const aiX, const sX, const bBool)
{
  decl va, i, ir;
  
  ir= 0;
  va= arglist();
  if (bBool == TRUE)
    aiX[0]= FALSE;
//   else if (bBool == -1)
//     aiX[0]= "";  
  for (i= 1; (i < sizeof(va)) && !ir; ++i)
    if (va[i] == sX)
      if (bBool == TRUE)
        ir= aiX[0]= TRUE;
      else if (bBool == -1)
        ir= sscan(va[++i], "%s", aiX);
      else 
        ir= sscan(va[++i], aiX);
        
  return ir;    
}
#endif
