/*
**  Program ExAcfQ.Ox
**
**  Purpose:
**    Example computing fewer ACF's
**
**  Author:
**    Charles Bos
**
**  Date:
**    12/9/2003
*/
#include <oxstd.h>
#include <packages/gnudraw/gnudraw.h>
#include <packages/oxutils/oxutils.h>

main()
{
  decl ma, vLag, n, mAcf;
  
  // Generate heavily correlated data
  n= 100000;
  ma= armagen(zeros(n, 1), rann(n, 1), <.995, .4>, 1, 1);

  // Compute ACF at base-10 frequencies
  vLag= 10 .^ range(0, 3, .25);
  mAcf= acfq(ma, vLag);

  // Show acf on normal scale  
  DrawXMatrix(0, mAcf', "Acf", vLag, "");
  DrawAdjust(ADJ_COLOR, 2, TP_USER, "impulses");
  DrawAxisAuto(0, TRUE);

  // Show acf on log-10 scale
  DrawXMatrix(1, mAcf', "Acf", vLag, "");
  DrawAdjust(ADJ_COLOR, 2, TP_USER, "impulses");
  DrawAdjust(ADJ_AXISSCALE, AXIS_LOG10, 1, 0, 1);
  DrawAxisAuto(1, TRUE);

  ShowDrawWindow();
}

