/*
**  Program ExInfo.ox
**
**  Purpose:
**    Provide an example of the usage of info.ox
**
**  Author:
**    Charles Bos
**
**  Date:
**    29/4/2002
*/
#include <oxstd.h>
#include <packages/oxutils/oxutils.h>

lengthycalculation(const iN)
{
  decl j, mX, mY;

  mX= rann(10, 10);
  for (j= 0; j < iN; ++j)
    mY= exp(mX);
}

main()
{
  decl i, iN, mX;

  iN= 1000;
  // First loop, initialized when i=0 by call info(0, iN)  
  for (i= 0; i < iN; ++i)
    {
      if (imod(i, 50)== 0)
        info(i, iN);

      mX= lengthycalculation(iN);
    }

  // Second loop, print info every 500 iterations or every second.
  infoinit(500, 1);
  for (i= 0; i < iN; ++i)
    { // No check on i necessary
      info(i, iN);

      mX= lengthycalculation(iN);
    }
}


