/*
**  Program ExLock.ox
**
**  Purpose:
**    Provide an example of the usage of lockfile.ox
**
**  Author:
**    Charles Bos
**
**  Date:
**    29/4/2002
*/
#include <oxstd.h>
#include <packages/oxutils/oxutils.h>

lengthycalculation(const iN, const sFilebase)
{
  decl j, mX, mY;

  println("Running computation for ", sFilebase, ".fmt");
  mX= rann(10, 10);
  for (j= 0; j < iN; ++j)
    mY= exp(mX);

  // Save the results  
  savemat(sFilebase~".fmt", mY);  
}

main()
{
  decl iN, mX;

  iN= 1000;
  println("Do some calculations, resulting in output res1.fmt");
  if (lockfile("res1"))
    mX= lengthycalculation(iN, "res1");
  else
    println ("Couldn't do the first iteration of the computation");  

  println("Second try will not succeed, as file res1 is still locked");
  if (lockfile("res1"))
    mX= lengthycalculation(iN, "res1");
  else
    println ("Couldn't do the second try of the computation");  
  
  println("Unlocking res1...");
  unlockfile("res1");  

  println("Third try works again, as file res1 is now unlocked");
  if (lockfile("res1"))
    mX= lengthycalculation(iN, "res1");
  else
    println ("Couldn't do the third try of the computation");  

  println("Unlocking res1...");
  unlockfile("res1");  
}


