/*
**  ExReadArg
**
**  Purpose:
**    Demonstrate the use of ReadArg
**
**  Date:
**    29/9/2005
**
**  Author:
**    Charles Bos
*/
#include <oxstd.h>
#include <packages/oxutils/oxutils.h>

main()
{
  decl iT, sVar, bGraph, vFix, asOther;
  
  iT= 1000;
  sVar= "nld";
  vFix= <1, 2, 3>;
  asOther= {"bel", "lux", "ger"};
  
  println ("ExReadArg\n=========");
  println ("Command line arguments:");
  println ("  it x                  integer, number of iterations");
  println ("  fix x1 x2 x3 .. x12   vector of integers, parameters to fix");
  println ("  var nld               string, variable to use");
  println ("  other bel lux ger     array of strings, other variables to use");
  println ("  graph                 boolean, if present graphs are shown");
  println ("\nUsage e.g.:");
  println ("  oxl exreadarg it 1000 var us fix 0 4");
  println ("  oxl exreadarg fix 0 1 7 2 4");
  
  // Check for a numerical command line argument
  ReadArg(&iT, "it", 1);

  // Check for a vector command line argument, maximum length= 12
  ReadArg(&vFix, "fix", 12);

  // Check for a string command line argument
  ReadArg(&sVar, "var", -1);
  
  // Check for an array of strings command line argument
  ReadArg(&asOther, "other", -3);
  
  // Check for a boolean command line argument
  ReadArg(&bGraph, "graph", 0);
  
  println ("\nUsing variable: ", sVar);
  println ("Sample size:    ", iT);
  if (sizerc(vFix))
    println ("Fixing pars: ", vFix);
  else
    println ("Not fixing pars");
  println (bGraph ? "Showing graphs" : "Not showing graphs");
  
  ReadArgUsed();

}
