/*
**  Program ExTable.Ox
**
**  Purpose:
**    Example creating LaTeX tables
**
**  Version:
**    1     Based on VaRisk.ox
**
**  Author:
**    Charles Bos
**    Patrick Houweling
**
**  Date:
**    16/6/2001   changed by Patrick to deal with improved PrintMat function
*/
#include <oxstd.h>
#include <packages/oxutils/oxutils.h>

main()
{
  decl i, aPrFmt, arLabs, acLabs, mX, nDim, mY, fh;

  // Get the data from the database
  nDim= 3;
  mX= rann(nDim, 1000);
  mY= meanr(mX)~varr(mX)~limits(mX')[:1][]';

  aPrFmt= acLabs= new array[nDim];
  for (i= 0; i < nDim; ++i)
    {
      aPrFmt[i]= "%7.3f";
      acLabs[i]= sprint("$R(", i, ")$");
    }
  arLabs= {"$\\mu$", "$\\sigma^2$", "min", "max"};

  // Print the table to a file, with one line before and after the
  //   table, two lines between the column headings and the table
  //   itself, and with the LaTeX tabular environment included
  fh= fopen("table.out", "a");
  PrintMatrix(fh, "extable", aPrFmt, acLabs, arLabs, 
              mY', 1, 2, TRUE);
  fh= fclose(fh);

  // Print the table to screen
  PrintMatrix(0, "extable", aPrFmt, acLabs, arLabs, 
              mY', 1, 2, TRUE);
}

