/*
**  Program ExTrack.ox
**
**  Purpose:
**    Provide an example of the usage of tractime.ox
**
**  Author:
**    Charles Bos
**
**  Date:
**    24/7/2000
*/
#include <oxstd.h>
#include <packages/oxutils/oxutils.h>

lengthycalculation(const iN, const iS)
{
  decl j, mX, mY;

  mX= rann(iS, iS);
  for (j= 0; j < iN; ++j)
    mY= exp(mX);

  return mY;
}

main()
{
  decl i, iN, mX, iSa, iSb, iOld;

  iN= 1000;
  iSa= 5; iSb= 10;
  TrackInit({"Routine A", "Routine B"});
  TrackRoutine(FALSE);        // Set to TRUE to see which routine is
                              // entered
  for (i= 0; i < iN; ++i)
    {
      if (imod(i, 50)== 0)
        TrackReport();

      iOld= TrackTime(0);     // iOld gets value 1
      mX= lengthycalculation(iN, iSa);

      iOld= TrackTime(1);     // iOld gets value 0
      mX= lengthycalculation(iN, iSb);
      TrackTime(-1);          // Outside the routines, stop time
    }
}


