/*
**  size.ox
**
**  Purpose:
**    Return size of matrix, a la Gauss
**
**  Author:
**    Charles Bos
**
**  Version:
**    1
**
**  Inputs:
**    ma    m x k matrix (or scalar)
**
**  Output:
**    r.v.        2 x 1 vector containing m|k
*/
#ifndef SIZE_INCLUDED
  #define SIZE_INCLUDED
  #include <oxstd.h>

size(const ma, ...)
{
  decl va, mS, i;
  va= va_arglist();
  mS= sizer(ma)|sizec(ma);
  for (i= 0; i < sizeof(va); ++i)
    mS~= sizer(va[i])|sizec(va[i]);
  return mS;    
}
#endif
