/*
**  wait.ox
**
**  Purpose:
**    Wait a prespecified time
**
**  Author:
**    Charles Bos
**
**  Version:
**    1
**
**  Inputs:
**    dTime     integer or double, time in seconds to wait. If <= 0, wait
**              for keypress
**
**  Output:
**    none
*/
#ifndef WAIT_INCLUDED
  #define WAIT_INCLUDED
  #include <oxstd.h>

wait(const dTime)
{
  decl dTime0, mX, sS;
  
  dTime0= timer();
  if (dTime > 0)
#ifdef OX_Linux
    systemcall(sprint("sleep ", dTime));
#else
    while (timer() - dTime0 < 100*dTime)
      mX= rann(1000, 1000);
#endif
  else  
    {
      print ("Press return...");
      scan("%z", &sS);
    }  
}
#endif
