/*
**  SsfSVWgt
**
**  Purpose:
**    Draw weight plots
**
**  Date:
**    26/4/2002
**
**  Author:
**    Charles Bos
*/
#include <oxstd.h>      // Include the Ox standard library header
#include <include/choosedraw.h>

#import "packages/oxutils/oxutils"
#import "include/ssfsv"

#include "simox.dec"

main()
{
  decl ssfsv, vY, vP, ir, dLnPdf, dTime, i, iZoom, va, mSm, mCSm;

  dTime= timer();
  println ("SsfSVWgt\n--------");
  println ("With a command line parameter, no estimation is done");
  setseed(g_iSeed);
    
  ssfsv= new SSFSV();
  ssfsv.LoadIn7(g_Datafile);

  ssfsv.Select(Y_VAR, {g_yVar, 0, 0});
  ssfsv.SetSelSample(g_Sample[0], g_Sample[1], g_Sample[2], g_Sample[3]);

  vY= ssfsv.GetVarByIndex(Y_VAR);
  ssfsv.SetMethod(g_iMethod);
  ssfsv.ChooseTransform(g_bTrans);
  ssfsv.ChooseModel(g_mStsm);

  vP= ssfsv.GetFreePar();
  ir= ssfsv.SSFSVLikelihood(vP, &dLnPdf, 0, 0);
  println ("Drawing weights for model ", g_sModel);
  print ("Initial likelihood: ", sizerc(vY)*dLnPdf, " at ",
         "%c", ssfsv.GetFreeParNames(), vP');

  va= arglist();
  if (sizeof(va) == 1)
    {
      print ("Optimizing...");
      ssfsv.Estimate();         
    }  

  if (rows(g_mWeight) == 0)
    g_mWeight= ssfsv.ObsYear(sizerc(vY)/2)~ssfsv.ObsPeriod(sizerc(vY)/2);
  mCSm= <>;    
  for (i= 0; i < rows(g_mWeight); ++i)
    {
      iZoom= ssfsv.GetIndex(g_mWeight[i][0], g_mWeight[i][1]);
      ssfsv.SaveGraphics(sprint(g_Outbase, "w", i));
      mSm= ssfsv.TestWeightGraphs(vP, iZoom);
      mCSm~= cumulate(mSm');
    }
    
  println ("Time passed: ", timespan(dTime));
  
}  
