/*
**  Program StFore_Cov.ox
**
**  Purpose:
**    Estimate coverage probabilities, as in Christoffersen
**
**  Version:
**    1, based on covarf4 in fiunemp6.zip
**
**  Date:
**    7/10/2002
**
**  Author:
**    Charles Bos
**
*/
#include <oxstd.h>      // Include the Ox standard library header
#include <include/choosedraw.h>

#import "packages/oxutils/oxutils"
#import "include/ssfsv"

#include "simox.dec"
#include "include/incinit.ox"

// Procedure declaration
UncondCov(const vEstim, const vRMSE, const vActual, const dp);
IndCov(const vEstim, const vRMSE, const vActual, const dp);
MinDifUC(const dP, const adFunc, const avScore, const amHessian);
MinDifUC2(const dP, const adFunc, const avScore, const amHessian);

static decl s_C_Min, s_C_p, s_C_n, s_C_LR, s_C_LnLp, s_C_LRbound,
            s_C_Plot= FALSE;

main()
{
  decl ssfsv, vY, vP, j, iFirst, iLast, iH, sFilebase, mFS, mE, mS,
       mX, vEst, sNames, asStat, asHor, iD, iK, fh, vSel, va, vH
  decl sOutbase, nH, iiH, ir, mResIHCum, 
       dp, vS2, vBeg, vBegEst, vEndEst, mLRucM, mLRucC, 
       mLRindM, mLRindC, i, aLine, s0, vn;


  println ("StFore_Cov\n-----------");
  println ("Optionally give horizons as parameters");
  println ("Arguments:");
  println ("  trans 1/0    Use (1) or don't (0) use transformation");
  println ("  h 1 3 6 12   Use these horizons");
  
  va= arglist();
  vH= range(1, g_Horiz);
  for (i= 1; i < sizeof(va); ++i)
    if (va[i] == "trans")
	  sscan(va[++i], &g_bTrans);
    else if (va[i] == "h")
      vH= <>;
    else
      {
        sscan(va[i], "%i", &j);
        vH~= j;
      }  
  InitStFore(vH, &ssfsv, &asHor, &vY, &vP, 
             &iFirst, &iLast, &sFilebase);

  dp= 0.6; 	// coverage probability
//   va= arglist();
//   if (sizeof(va) > 1)
//     sscan(va[1], "%f", &dp);

  fopen("excl/covarf4.out", "l");

  println ("Writing output to ", sFilebase, "XXX");
  println ("Calculating ", dp*100, "\% coverage probability");

  mFS= loadmat(sprint(sFilebase, g_Horiz, "fs.fmt"));
  if (mFS[][0] != sortc(mFS[][0]))
    oxrunerror("Error: Results not correctly sorted", 1);
  println ("Using ", rows(mFS), " results");
  mE= mFS[][1:(columns(mFS)-1)/2];
  mS= mFS[][(columns(mFS)+1)/2:];
  
  nH= sizerc(vH);
  mLRucC= new matrix [5][nH];
  mLRindC= new matrix [2][nH];
  vS2= vn= new matrix [1][nH];
  
  for (iiH= 0; iiH < nH; ++iiH)
    {
      iH= vH[iiH];
      println ("Starting with horizon ", iH);

      vSel= range(iFirst, iLast, iH);
      mLRucC[][iiH]= UncondCov(mE[vSel-iFirst][iH-1], sqrt(mS[vSel-iFirst][iH-1]), 
                               0, dp);
      mLRindC[][iiH]= IndCov(mE[vSel-iFirst][iH-1], sqrt(mS[vSel-iFirst][iH-1]), 
                             0, dp);
      vS2[iiH]= dp*(1-dp)/(sizerc(vSel)+1);

      vn[iiH]= sizerc(vSel);
    }

  println ("Model version: \n", g_sModel);
  println ("iH, pHat, LRuc test and p value cumulative pred: ", 
           vH|mLRucC[:2][]);
  print ("Confidence bounds: ", "%6.3f", 
         dp+<-1; 1>.*quann(0.975)*sqrt(vS2));
  println ("Alternative confidence bounds: ");
  PrintMatrix(0, "", "%5.3f", "", {"$L_c$", "$U_c$"},
              mLRucC[3:][], FALSE);
  print (mLRucC[0][]-mLRucC[3:][]);
  print ("Effectively available forecasts: ", "%6.0f", vn);
  println ("LRind test and p value cumulative pred: ", 
           mLRindC);

  j= strfindr(g_Outbase, "/")+1;
  s0= g_Outbase[j:];

  aLine= s0;
  for (i= 0; i < nH; ++i)
    {
      aLine= sprint(aLine, " & ", "%.2f", mLRucC[0][i]);
      if ((mLRucC[0][i] < mLRucC[3][i]) || 
          (mLRucC[0][i] > mLRucC[4][i]))
        aLine= sprint(aLine, "^\\ast");
    }
  
  fh= fopen("excl/covuc.out", "a");
  fprintln (fh, aLine, " \\\\");
  fh= fclose(fh);
  println("UC: ", aLine);

  fh= fopen("excl/covarf.out", "a");
  fprintln (fh, aLine, " \\\\");
  aLine= "  &";
  for (i= 0; i < nH; ++i)
    aLine= sprint(aLine, " & [", "%.4f]", mLRucC[2][i]);
  fprintln (fh, aLine, " \\\\");
  fh= fclose(fh);

  aLine= s0;
  for (i= 0; i < nH; ++i)
    {
      if (!isnan(mLRindC[0][i]))
        {
         aLine= sprint(aLine, " & ", "%.2f", mLRindC[0][i]);
         if (mLRindC[1][i] <= .05)
           aLine= sprint(aLine, "^\\ast");
        }
      else
        aLine= sprint(aLine, " & .");
    }
  fh= fopen("excl/covind.out", "a");
  fprintln (fh, aLine, " \\\\");
  fh= fclose(fh);
  println ("IC: ", aLine, " \\\\");
}

/*
**  UncondCov(const vEstim, const vRMSE, const vActual, const dp);
**
**  Purpose:
**	  Calculate the unconditional probability test of Christoffersen,
**    for a coverage of p
*/
UncondCov(const vEstim, const vRMSE, const vActual, const dp)
{
  decl ve, iN0, iN1, dCrit, vL, dpHat, dLRuc, dpLRuc, dPL, dPU, dFunc, 
       ir1, ir2, dLnLp, dLnLpi, sLab;
  
  ve= (vEstim-vActual)./vRMSE;
  dCrit= quann(1-(1-dp)/2);
  vL= (fabs(ve) .<= dCrit);
  iN1= sumc(vL);
  iN0= sumc(1-vL);
  dpHat= iN1/(iN0+iN1);
  
  // Unconditional coverage
  dLnLp= iN0*log(1-dp) + iN1*log(dp);
  dLnLpi= iN0*log(1-dpHat) + iN1*log(dpHat);
  dLRuc= -2*(dLnLp - dLnLpi);
  dpLRuc= 1-probchi(dLRuc, 1);

  s_C_n= iN0+iN1;
  s_C_LRbound= quanchi(0.95, 1);
  s_C_p= dp;

  dPL= dPU= dp;
  s_C_Min= TRUE;
  ir1= MaxBFGS(MinDifUC2, &dPL, &dFunc, 0, 1);
  if (ir1 != MAX_CONV)
    {
      println (MaxConvergenceMsg(ir1), dPL~s_C_LRbound~dFunc~iN0~iN1);
      if (dPL < 1e-5)
        dPL= 0;
    }

  s_C_Min= FALSE;
  ir2= MaxBFGS(MinDifUC2, &dPU, &dFunc, 0, 1);
  if (ir2 != MAX_CONV)
    {
      println (MaxConvergenceMsg(ir2), dPU~s_C_LRbound~dFunc~iN0~iN1);
      if (dPU > 1-1e-5)
        dPU= 1;
    }

  if (s_C_Plot && ((ir1 != MAX_CONV) || (ir2 != MAX_CONV)))
    {
      vL= range(dPL, dPU, (dPU-dPL)/100);
      MinDifUC2(vL, &dFunc, 0, 0);
      sLab= "";
      if (ir1 != MAX_CONV)
        sLab= "left ";
      if (ir2 != MAX_CONV)
        sLab~= "right";
      DrawXMatrix(0, s_C_LR, sLab, vL, "");
      DrawXMatrix(0, s_C_LRbound~s_C_LRbound, "", limits(vL')[:1]', "");
      ShowDrawWindow();
    }
  
  return dpHat|dLRuc|dpLRuc|dPL|dPU;
}

/*
**  IndCov(const vEstim, const vRMSE, const vActual, const dp);
**
**  Purpose:
**	Calculate the independence test of Christoffersen
*/
IndCov(const vEstim, const vRMSE, const vActual, const dp)
{
  decl ve, dCrit, vL, iN, iN00, iN01, iN10, iN11, 
       miN1, mPi1, dL1, dPi2, dL2, dLRind, dpLRind;
  
  ve= (vEstim-vActual)./vRMSE;
  dCrit= quann(1-(1-dp)/2);
  vL= (fabs(ve) .<= dCrit);

  iN= rows(vL);
  iN00= sumc((vL[1:] .== 0) .&& (vL[:iN-2] .== 0));
  iN01= sumc((vL[1:] .== 1) .&& (vL[:iN-2] .== 0));
  iN10= sumc((vL[1:] .== 0) .&& (vL[:iN-2] .== 1));
  iN11= sumc((vL[1:] .== 1) .&& (vL[:iN-2] .== 1));
//  print (iN00~iN01~iN10~iN11);
  miN1= (iN00~iN01)|(iN10~iN11);
  mPi1= ((iN00/(iN00+iN01)~iN01/(iN00+iN01))|(iN10/(iN10+iN11)~iN11/(iN10+iN11)));
  dL1= sumc(vec(miN1.*log(mPi1)));
  
  dPi2= (iN01+iN11)/iN;
  dL2= (iN00+iN10)*log(1-dPi2)+(iN01+iN11)*log(dPi2);

  // Independence test
  dLRind= -2*(dL2-dL1);
  dpLRind= 1-probchi(dLRind, 1);

  return dLRind|dpLRind;
}

/*
**  MinDifUC2(const dP, const adFunc, const avScore, const amHessian)
**
**  Purpose:
**    In order to calculate the confidence bounds, here the squared
**    distance between the LR test and the chi-2 bound is calculated.
*/
MinDifUC2(const dP, const adFunc, const avScore, const amHessian)
{
  decl dLnLpi, dLnLp, dLRp, iN0, iN1, ir;

  ir= 0;
  if (((dP == s_C_p) || (s_C_Min == (dP < s_C_p))) && (dP <= 1))
    {
      // Calculate the number of successes and losses corresponding to p
      iN0= (1-dP)*s_C_n;
      iN1= dP*s_C_n;

      // Calculate the logl's, for the alternative and the null
      dLnLpi= iN0.*log(1-dP) + iN1.*log(dP);
      dLnLp= iN0.*log(1-s_C_p) + iN1.*log(s_C_p);;
      s_C_LR= -2*(dLnLp-dLnLpi);

      adFunc[0]= -sqr(s_C_LR-s_C_LRbound);
      ir= !isnan(adFunc[0]);
    }

//  adFunc[0]= dLRp;
  return ir;
}

