/*
**  StFore_Tab
**
**  Purpose:
**    Create the tables concerning the MFE/MAPE/RMSE
**
**  Date:
**    3/10/2002
**
**  Author:
**    Charles Bos
*/
#include <oxstd.h>      // Include the Ox standard library header
#include <include/choosedraw.h>

#import "packages/oxutils/oxutils"
#import "include/ssfsv"

#include "simox.dec"
#include "include/incinit.ox"

main()
{
  decl ssfsv, vY, vP, i, j, iFirst, iLast, iH, sFilebase, mFS, mE, mS,
       mPar, asHor, iK, vSel, vH, va;

  println ("StFore_Fig\n-----------");
  println ("Optionally give horizons as parameters");
  println ("Arguments:");
  println ("  trans 1/0    Use (1) or don't (0) use transformation");
  println ("  h 1 3 6 12   Use these horizons");
  
  va= arglist();
  vH= range(1, g_Horiz);
  for (i= 1; i < sizeof(va); ++i)
    if (va[i] == "trans")
	  sscan(va[++i], &g_bTrans);
    else if (va[i] == "h")
      vH= <>;
    else
      {
        sscan(va[i], "%i", &j);
        vH~= j;
      }  
  InitStFore(vH, &ssfsv, &asHor, &vY, &vP, 
             &iFirst, &iLast, &sFilebase);
  iH= max(vH);
  asHor= sprint(iH);
  iK= sizerc(vP);

  // Load results
  println ("Analysing results from ", sFilebase, g_Horiz, "fs.fmt");
  mFS= loadmat(sprint(sFilebase, g_Horiz, "fs.fmt"));
  vSel= vecrindex(sumr(mFS[][0] .== range(iFirst, iLast)));
  println ("Using ", sizerc(vSel), " results");
  mE= mFS[vSel][1:iH];
  mS= mFS[vSel][iH+1:];
  
  mPar= loadmat(sFilebase~"par.fmt");
  vSel= vecrindex(sumr(mPar[][0] .== range(iFirst, iLast)));
  mPar= mPar[vSel][];
  
  DrawTMatrix(0, vY[iH+iFirst:iH+iLast]', sprint(g_sModel, " h=", iH), 
              ssfsv.ObsYear(iFirst+iH), ssfsv.ObsPeriod(iFirst+iH), ssfsv.GetFrequency());
  DrawTMatrix(0, vY[iH+iFirst:iH+iLast]'-mE[][iH-1]', "F",
              ssfsv.ObsYear(iFirst+iH), ssfsv.ObsPeriod(iFirst+iH),
              ssfsv.GetFrequency(), 0, 3);
              
//   print ("Voor iH= ", iH, " start ik met Y: ", iH+iFirst, " tot aan ",
//          iH+iLast, " met de hele mE. Grootte van Y en E: ", size(vY, mE));              
  DrawTitle(0, g_sModel);
  SaveDrawWindow(sprint(sFilebase, g_Horiz, "fe"~CH_FIGEXT));
  ShowDrawWindow();                      

  DrawTMatrix(0, mE[][iH-1]'|0, sprint("E, h= ", iH),
              ssfsv.ObsYear(iFirst+iH), ssfsv.ObsPeriod(iFirst+iH),
              ssfsv.GetFrequency());
  DrawZ(sqrt(mS[][iH-1]'), "", ZMODE_BAND, 2, 3);
  DrawTitle(0, g_sModel);
  SaveDrawWindow(sprint(sFilebase, g_Horiz, "pe"~CH_FIGEXT));
  ShowDrawWindow();                      

  for (i= 0; i< iK; ++i)
    {
      DrawTMatrix(i, mPar[][3+i]', ssfsv.GetParNames()[i],
                  ssfsv.ObsYear(iFirst), ssfsv.ObsPeriod(iFirst),
                  ssfsv.GetFrequency());
      DrawZ(mPar[][3+i+iK]', "", ZMODE_BAND, 1, 3);
    }  
  DrawTitle(-1, g_sModel);
  SaveDrawWindow(sprint(sFilebase, "par"~CH_FIGEXT));
  ShowDrawWindow();                      
  
  
  
}  

