/*
**  StFore_Tab
**
**  Purpose:
**    Create the tables concerning the MFE/MAPE/RMSE
**
**  Version 3:
**    Use output from stfore2.ox
**
**  Date:
**    3/10/2002
**
**  Author:
**    Charles Bos
*/
#include <oxstd.h>      // Include the Ox standard library header
#include <include/choosedraw.h>

#import "packages/oxutils/oxutils"
#import "include/ssfsv"

#include "simox.dec"
#include "include/incinit.ox"

main()
{
  decl ssfsv, vY, vP, i, j, iFirst, iLast, iH, sFilebase, mFS, mE, mS,
       mX, vEst, sNames, asStat, asHor, iD, iK, fh, vSel, va, vH;

  println ("StFore_Tab\n-----------");
  println ("Optionally give horizons as parameters");
  println ("Arguments:");
  println ("  trans 1/0    Use (1) or don't (0) use transformation");
  println ("  h 1 3 6 12   Use these horizons");
  
  va= arglist();
  vH= range(1, g_Horiz);
  for (i= 1; i < sizeof(va); ++i)
    if (va[i] == "trans")
	  sscan(va[++i], &g_bTrans);
    else if (va[i] == "h")
      vH= <>;
    else
      {
        sscan(va[i], "%i", &j);
        vH~= j;
      }  
  InitStFore(vH, &ssfsv, &asHor, &vY, &vP, 
             &iFirst, &iLast, &sFilebase);
  iH= max(vH);             

  // Load results
  println ("Analysing results from ", sFilebase, g_Horiz, "fs.fmt");
  mFS= loadmat(sprint(sFilebase, g_Horiz, "fs.fmt"));
  vSel= vecrindex((mFS[][0] .>= iFirst) .&& (mFS[][0] .<= iLast));
  println ("Using ", sizerc(vSel), " results");
  mE= mFS[vSel][1:iH];
  mS= mFS[vSel][iH+1:];
  
  mX= meanc(mE)|            // MFE
      meanc(fabs(mE))|      // MAPE
      sqrt(meanc(sqr(mE)))| // RMSE
      sqrt(meanc(mS));      // RMSEmod
  
  asStat= {"MFE", "MAPE", "RMSE", "RMSEmod"};
  fh= fopen("excl/stfore_tab.out", "a");
  if (!isfile(fh))
    fh= fopen("excl/stfore_tab.out", "w");
  j= strfindr(g_Outbase, "/")+1;
  PrintMatrix(fh, g_Outbase[j:], "%8.3f", asHor, asStat, 
              mX[][vH-1], TRUE); 
  fh= fclose(fh);              
  PrintMatrix(0, g_Outbase[j:], "%8.3f", asHor, asStat, 
              mX[][vH-1], TRUE); 
}  

