/*
**  StFore
**
**  Purpose:
**    Estimate and forecast the models for the inflation or ip data using SSFSV
**
**  Version:
**    2, using weights for constructing forecast of h
**
**  Date:
**    3/10/2002
**
**  Author:
**    Charles Bos
*/
#include <oxstd.h>      // Include the Ox standard library header
#include <include/choosedraw.h>

#import "packages/oxutils/oxutils"
#import "include/ssfsv"

#include "simox.dec"

main()
{
  decl ssfsv, vY, vP, ir, dLnPdf, iSim,
       dTime, vS, dLL, vE, i, iFirst, iLast, iEst, iSel, iK,
       iH, mP, mFor, sFilebase, vDone, fh, bSV, va;

  dTime= timer();
  println ("StForecast\n-------");
  println ("Arguments:");
  println ("  trans 1/0    Use (1) or don't (0) use transformation");
  va= arglist();
  for (i= 1; i < sizeof(va); ++i)
    if (va[i] == "trans")
	  sscan(va[++i], &g_bTrans);
    else if (va[i] == "sim")
	  sscan(va[++i], &iSim);
  // For forecasting, take a new seed
  setseed(0);
    
  ssfsv= new SSFSV();
  ssfsv.LoadIn7(g_Datafile);

  ssfsv.Select(Y_VAR, {g_yVar, 0, 0});
  ssfsv.SetSelSample(g_Sample[0], g_Sample[1], g_Sample[2], g_Sample[3]);
  ssfsv.Info();

  vY= ssfsv.GetVar(g_yVar);

  // Get the first forecasting date  
  iFirst= ssfsv.GetIndex(g_Forec[0], g_Forec[1]);
  iFirst= max(0, iFirst);
  g_Forec[0]= ssfsv.ObsYear(iFirst);
  g_Forec[1]= ssfsv.ObsPeriod(iFirst);
  
  // Set the last forecasting date
  iLast= (min(g_Forec[2:]) == -1) ? sizerc(vY) :
         ssfsv.GetIndex(g_Forec[2], g_Forec[3]);
  iLast= min(iLast, sizerc(vY)-max(g_Horiz));
  g_Forec[2]= ssfsv.ObsYear(iLast);
  g_Forec[3]= ssfsv.ObsPeriod(iLast);
  
  bSV= !(g_mStsm[][0] != CMP_SV);
  iH= g_Horiz;

  ssfsv.SetMethod(g_iMethod);
  ssfsv.ChooseTransform(g_bTrans);
  ssfsv.ChooseModel(g_mStsm);
  ssfsv.ChooseSVRep(-1, iSim);

  vP= ssfsv.GetFreePar();
  ir= ssfsv.SSFSVLikelihood(vP, &dLnPdf, 0, 0);

  println ("Estimating model ", g_sModel);
  print ("Initial likelihood: ", sizerc(vY)*dLnPdf, " at ",
         "%c", ssfsv.GetFreeParNames(), vP');
  ssfsv.Debug(0);
  
  i= strfindr(g_Outbase, "/")+1;
  sFilebase= sprint("excl/forecast/", g_Outbase[i:], "r", g_bTrans);
  println ("Writing results to ", sFilebase, iH, "fs.fmt");
  
  if (!lockfile(sFilebase))
    oxrunerror ("Returning", 1);
  
  // Check what dates have been estimated
  mP= loadmat(sFilebase~"par.fmt");
  vDone= sizerc(mP) ? mP[][0] : <>;
  print ("Using ", sizerc(vDone), " old estimations");

  // Start the files if necessary
  fh= fopen(sFilebase~"par.fmt", "abf");
  if (!isfile(fh))
    fh= fopen(sFilebase~"par.fmt", "wbf");
  fh= fclose(fh);    
  fh= fopen(sprint(sFilebase, iH, "fs.fmt"), "wbf");
  fh= fclose(fh);    
  
//  ssfsv.SetPrint(FALSE);
  
  // Turn off correct iterative sampling if you want; if you turn it
  // off, the residuals are scaled by the smoothed variances, instead
  // of by the filtered variances. As filtering the variances (in the 
  // present implementation) takes considerable time, the option is
  // presented here
  ssfsv.ChoosePredIter(g_bPredIter);

  MaxControl(-1, 0);
  infoinit(5, 5);
  for (i= 0; i < iLast-iFirst; ++i)
    {
      info(i, iLast-iFirst);
      iEst= iFirst+i;
      ssfsv.SetSelSample(g_Sample[0], g_Sample[1],
                         ssfsv.ObsYear(iEst),
                         ssfsv.ObsPeriod(iEst));

      // Check if this element had already been done
      if (!(vDone != iEst))
        {
          iSel= vecrindex(vDone .== iEst);
          println ("Estimation at date ", ssfsv.ObsYear(iEst), 
                   ":", ssfsv.ObsPeriod(iEst), " was done, continuing");
          iK= (columns(mP)-3)/2;
          vP= mP[iSel][3:2+iK]';
          ssfsv.SetFreePar(vP);
          ir= ssfsv.SSFSVLikelihood(vP, &dLnPdf, 0, 0);
        }  
      else
        {  
          ssfsv.Estimate();
          vP= ssfsv.GetFreePar();
          vS= ssfsv.MapParToFree(ssfsv.GetStdErr());
          dLL= ssfsv.GetLogLik();
          ir= ssfsv.GetResult();

          fh= fopen(sFilebase~"par.fmt", "abf");
          if (!fwrite(fh, iEst~ir~dLL~vP'~vS'))
            oxrunerror("Trouble writing file", 1);
          fh= fclose(fh);
        }
      // Forecast ahead
      mFor= ssfsv.SVForecast(iH);
      vE= vY[iEst+1:iEst+iH]' - mFor[0][];

      fh= fopen(sprint(sFilebase, iH, "fs.fmt"), 
                "abf");
      if (!fwrite(fh, iEst~vE~mFor[1][]))
        oxrunerror("Trouble writing file", 1);
      fh= fclose(fh);
    }
  info(iLast-iFirst, iLast-iFirst);
  unlockfile(sFilebase);

  println ("Time passed: ", timespan(dTime));
}  

