/*
**  SVISSim_Res
**
**  Purpose:
**    Show results
**
**  Version:
**    7     Fit format to article.
**
**  Date:
**    22/3/2002
**
**  Author:
**    Charles Bos
*/
#include <oxstd.h>      // Include the Ox standard library header
#include <include/choosedraw.h>
#import "packages/oxutils/oxutils"
#import "include/ssfsv"

Initialize(const va);
PlaceStat(const vIn, const sLabIn, const amOld, const aasLabOld);
ReadResults(const amOld, const aasLabOld, const ssfsv, const asEst, const vSample,
            const asTest, mDF, const mGenrSV, const iT);
PlotTests(const ssfsv, const amSim, const asEst, const vSample,
          const asTest, mDF, const iT);
PlotParameters(const ssfsv, const amSim, const asEst, const vSample,
               const asTest, const mGenrSV, const iT);
PlotSParameters(const ssfsv, const amSim, const asEst, const vSample,
                const asTest, const mGenrSV, const iT);

#include "simox.dec"

main()
{
  decl ssfsv, asEst, asTest, asLabOld, asLabs, vSel, vSample,
       mOld, amSim, iT, mGenrSV, mDF, mSV, asNames, i;
  
  [ssfsv, mGenrSV, iT]= Initialize(arglist());
  asEst= {"No SV", "SV"};
  asTest= {"Normality-DH:", "Q:", "ARCH:", sprint("H(",
             double(round(iT/3)), "):"), "LL", "ir"};
  vSample= <100, 500, 1000>;
  mDF= zeros(7,2);
  mDF[0][0]= 2;
  mDF[1][]= -1~0;   // Is recomputed later
  mDF[2][]= -1~0;    // Is recomputed later
  mDF[3][]= round(iT/3)~round(iT/3);

  // Get labels of summary statistics
  ssfsv.ChooseModel(g_mStsm|mGenrSV);
      
  amSim= ReadResults(&mOld, &asLabOld, ssfsv, asEst, vSample,
                     asTest, mDF, mGenrSV, iT);
//   PlotTests(ssfsv, amSim, asEst, vSample, asTest, mDF, iT);
//   PlotParameters(ssfsv, amSim, asEst, vSample,
//                  asTest, mGenrSV, iT);
//   PlotSParameters(ssfsv, amSim, asEst, vSample,
//                   asTest, mGenrSV, iT);
   
  mSV= <CMP_SV, .2, 0, .9>;
  ssfsv.ChooseModel(g_mStsm|mSV);
  asNames= ssfsv.GetParNames();
  println("Results for ", g_Outbase, g_bGenrSV);
  mOld= deleteifc(mOld, minc(isdotnan(mOld)));
  asLabs= {"True", "Mu", "s", "p", "Mu", "s", "p", 
           "Mu", "s", "p", "Mu", "s", "p", 
           "Mu", "s", "p", "Mu", "s", "p", 
           "Mu", "s", "p", "Mu", "s", "p"};
//   PrintMatrix(0, "", {"%5.2f"}, asLabs,
//               asLabOld, mOld, 1);

  vSel= <>;
  for (i= 0; i < columns(mOld); ++i)
    if (asLabs[i] != "p")
      vSel~= i;
  PrintMatrix(0, "", {"%5.2f"}, asLabs[vSel],
              asLabOld, mOld[][vSel], 1);
}  

/*
**  Initialize
**
*/
Initialize(const va)
{
  decl nI, ssfsv, mSV, mSim, sOutbase, iT, mPhi,
       mOmega, mSigma;
  
  println("SVISSIM_RES\n-----------");
  println("Call as \n  oxl svissim_res3 <genr>");
  println("where <genr>= 0, 1");
  
  if ((sizeof(va) > 1) && sscan(va[1], "%i", &nI))
    g_bGenrSV= nI;
  #ifdef GNUDRAW_INCLUDED
  if ((sizeof(va) > 2) && (va[2] == "nofig"))
    DrawAdjust(ADJ_SHOW, FALSE);
  #endif  
  if ((g_Sample < 100) || (max(g_bGenrSV, g_bEstSV) > 2))  
    oxrunerror(sprint("Error: Incorrect parameters, nRep= ", g_nRep,
      ", nSample= ", g_Sample[3], ", bGenrSV= ", g_bGenrSV, ", bEstSV= ", 
      g_bEstSV), 1);

  ssfsv= new SSFSV();
  ssfsv.Debug(0);
  ssfsv.Create(g_Sample[0], g_Sample[1], g_Sample[2],
               ceil(g_Sample[3]/g_Sample[0]), g_Sample[4]);
  ssfsv.SetSelSample(-1, -1, -1, -1);
  ssfsv.Deterministic(0);
  ssfsv.Append(ssfsv.GetVar("Constant"), {"Y"});
  ssfsv.Select(Y_VAR, {"Y", 0, 0});
  ssfsv.Info();
  ssfsv.SetMethod(ESTM_INIT);

  mSV= g_bGenrSV == 0 ? <> :
       g_bGenrSV == 1 ? <CMP_SV, .2, 0, .9> :
       <CMP_SV, .2, 0, 1>;
  ssfsv.ChooseModel(g_mStsm|mSV);
          
  if (g_mStsm[][0] != CMP_ARMA)
    GetSsfStsm(g_mStsm, &mPhi, &mOmega, &mSigma);
  else
    GetSsfArma(g_mStsm[][2], g_mStsm[][3], g_mStsm[0][1], 
               &mPhi, &mOmega, &mSigma);
  iT= sizerc(ssfsv.GetVar("Constant")) - sumc(vecr(mSigma .== -1));
  
  return {ssfsv, mSV, iT};          
}


/*
**  PlaceStat(const vIn, const sLabIn, const amOld, const aasLabOld)
*/
PlaceStat(const vIn, const sLabIn, const amOld, const aasLabOld)
{
  decl j, iC;
  
  // Place statistics
  j= strfind(aasLabOld[0], sLabIn);
  
  if (j < 0)
    {
      j=rows(amOld[0]);
      amOld[0]|= constant(M_NAN, 1, max(sizerc(vIn), columns(amOld[0])));
      aasLabOld[0]~= sLabIn;
    }
  iC= columns(amOld[0])-sizerc(vIn);
  amOld[0][j][iC:]= vecr(vIn)';
  
  return j;
}

/*
**  ReadResults()
*/
ReadResults(const amOld, const aasLabOld, const ssfsv, const asEst,
            const vSample, const asTest, mDF, const mGenrSV, const iT)
{
  decl iS, iE, amSim, iSample, iEstSV, mSim, sOutbase, mSV, vP, 
       asNames, iK, iC, i, j, vOut, iA, asPlot, dftest, df1, df2;
  
  iS= sizerc(vSample);
  iE= sizeof(asEst);
  iA= double(round(sqrt(iT)));
  amSim= new array [iS];  
  
  // Put 'Truth' in the output
  amOld[0]= <>;
  aasLabOld[0]= {};
        
  // Place test statistics
  vOut= M_NAN~M_NAN~M_NAN;
  for (i= 0; i < sizeof(asTest); ++i)
    PlaceStat(vOut, asTest[i], amOld, aasLabOld);

  // Place parameter estimates
  asNames= ssfsv.GetFreeParNames();
  for (i= 0; i < sizeof(asNames); ++i)
    {
      vOut= ssfsv.GetFreePar()[i]~M_NAN~M_NAN;
      PlaceStat(vOut, asNames[i], amOld, aasLabOld);
    }

  mSV= mGenrSV == <> ? <CMP_SV, 0, 0, 0> :
       mGenrSV;
  ssfsv.ChooseModel(g_mStsm);
  ssfsv.ChooseModel(g_mStsm|mSV);
  vP= ssfsv.GetFreePar();
  asPlot= ssfsv.GetFreeParNames();

  for (iSample= 0; iSample < iS; ++iSample)
    {
      amSim[iSample]= new array [iE];
      for (iEstSV= 0; iEstSV < iE; ++iEstSV)
        {
          sOutbase= sprint(g_Outbase, g_bGenrSV, iEstSV, "_", vSample[iSample]);
          mSim= amSim[iSample][iEstSV]= loadmat(sOutbase~"res.fmt");

          // Enlarge mOld
          amOld[0]~= constant(M_NAN, rows(amOld[0]), 3);

          if (!rows(mSim))
            {
              println ("Trouble loading ", sOutbase, "res.fmt");
              continue;
            }  

          println ("Analyzing ", sOutbase, "res.fmt with ", rows(mSim), " simulations");

          mSV= iEstSV == 0 ? <> :
               iEstSV == 1 ? CMP_SV~g_vSV[0]~0~g_vSV[1] :
               CMP_SV~g_vSV[0]~0~1;
          ssfsv.ChooseModel(g_mStsm|mSV);
          mDF[1][0]= iA+1-ssfsv.GetFreeParCount();
          GetFapproximation(ssfsv.GetFreeParCount(), vSample[iSample]-1,
                            1, 1, &dftest, &df1, &df2);
          mDF[2][]= df1~df2;

          asNames= ssfsv.GetFreeParNames();
          iK= sizeof(asNames);
          iC= columns(amOld[0]);
          
          // Place test statistics
          for (i= 0; i < sizeof(asTest); ++i)
            { vOut= meanc(deleter(mSim[][2*iK+i]))~
                    (mDF[i][0] > 0 ? 
                     meanc(ssfsv.PrintTestVal(mSim[][2*iK+i], mDF[i][0],
                                              mDF[i][1], "", FALSE) .<
                                              0.05) :
                     sqrt(varc(deleter(mSim[][2*iK+i]))))~
                    M_NAN;
              PlaceStat(vOut, asTest[i], amOld, aasLabOld);
              if (isnan(vOut[0]))
                oxrunerror(sprint("Trouble with ", asTest[i], mSim[][2*iK+i]',
                                  "asTest: ", asTest, "Size mSim: ",
                                  size(mSim)'), 1);
            }
              
          // Place parameter estimates
          for (i= 0; i < iK; ++i)
            {
              j= strfind(asPlot, asNames[i]);

              // Save mean parameter, sdev of sample and 
              //   proportion of estimates significantly different from
              //   truth
              vOut= meanc(mSim[][i])~
                    sqrt(varc(mSim[][i]))~
                    meanc(fabs((mSim[][i]-vP[j])./sqrt(varc(mSim[][i]))) .> quant(0.975, iK));
              PlaceStat(vOut, asNames[i], amOld, aasLabOld);
            }  
        }              
    }  
  return amSim;  
}

/*
**  PlotTests()
*/
PlotTests(const ssfsv, const amSim, const asEst, const vSample,
          const asTest, mDF, const iT)
{
  decl iS, iE, iA, iSample, iEstSV, iC, i, vX, vY, vMaxY, mSV;
  
  iS= sizerc(vSample);
  iE= sizeof(asEst);
  iA= double(round(sqrt(iT)));
  vMaxY= zeros(1, sizeof(asTest));
  
  for (iSample= 0; iSample < iS; ++iSample)
    {
      for (iEstSV= 0; iEstSV < iE; ++iEstSV)
        {
          mSV= iEstSV == 0 ? <> :
               iEstSV == 1 ? CMP_SV~g_vSV[0]~0~g_vSV[1] :
               CMP_SV~g_vSV[0]~0~1;
          ssfsv.ChooseModel(g_mStsm|mSV);
          mDF[1][0]= iA+1-ssfsv.GetFreeParCount();

          iC= columns(amSim[iSample][iEstSV])-sizeof(asTest);          
          // Place test statistics
          for (i= 0; i < sizeof(asTest); ++i)
            { 
              [vX, vY]= DrawDensity(i, amSim[iSample][iEstSV][][iC+i]', asTest[i], TRUE, FALSE, FALSE, 
                                    FALSE, FALSE, 0, 2+iEstSV);
              vMaxY[i]= max(vMaxY[i], vY);
            }
        }              
 
      // Draw truth
      for (i= 0; i < sizeof(asTest); ++i)
        {
          vX= mDF[i][1] > 0 ? quanf(0.95, mDF[i][0], mDF[i][1]) :
              mDF[i][0] > 0 ? quanchi(0.95, mDF[i][0]) :
              M_NAN;
          DrawXMatrix(i, 0~vMaxY[i], "", vX~vX, "", 0, 1);
        }  
      SaveDrawWindow(sprint(g_Outbase, g_bGenrSV, "_", vSample[iSample],
                            "test"~CH_FIGEXT));
      ShowDrawWindow();   
    }  
}

/*
**  PlotParameters()
*/
PlotParameters(const ssfsv, const amSim, const asEst, const vSample,
               const asTest, const mGenrSV, const iT)
{
  decl iS, iE, iSample, iEstSV, i, j, asPlot, asNames, 
       vX, vY, vMaxY, vP, iK, vT, mSV, mSim;
  
  iS= sizerc(vSample);
  iE= sizeof(asEst);
  
  mSV= mGenrSV == <> ? <CMP_SV, 0, 0, 0> :
       mGenrSV;
  ssfsv.ChooseModel(g_mStsm);
  ssfsv.ChooseModel(g_mStsm|mSV);
  vP= ssfsv.GetFreePar();
  asPlot= ssfsv.GetFreeParNames();

  vMaxY= zeros(1, 3*sizerc(vP));

  for (iSample= 0; iSample < iS; ++iSample)
    {
      for (iEstSV= 0; iEstSV < iE; ++iEstSV)
        {
          mSV= iEstSV == 0 ? <> :
               iEstSV == 1 ? CMP_SV~g_vSV[0]~0~g_vSV[1] :
               CMP_SV~g_vSV[0]~0~1;
          ssfsv.ChooseModel(g_mStsm|mSV);
          iK= ssfsv.GetFreeParCount();
          asNames= ssfsv.GetFreeParNames();
          
          mSim= deleter(amSim[iSample][iEstSV]);

          for (i= 0; i < iK; ++i)
            {
              j= strfind(asPlot, asNames[i]);
              [vX, vY]= DrawDensity(j, mSim[][i]', asEst[iEstSV], TRUE,
                                    FALSE, FALSE,  FALSE, FALSE, 0,
                                    2+iEstSV);
              vMaxY[j]= max(vMaxY[j], vY);                                       
              if ((iEstSV == 2) && (asNames[i] == "s(SV)"))
                DrawAdjust(ADJ_AXES2ND, 0, 1);
              DrawText(j, asNames[i], M_NAN, M_NAN, M_NAN, M_NAN,
                       TEXT_XLABEL);

              [vX, vY]= DrawDensity(j+sizerc(vP), mSim[][i+iK]', asEst[iEstSV], TRUE,
                                    FALSE, FALSE, FALSE, FALSE, 0,
                                    2+iEstSV);
              DrawText(j+sizerc(vP), sprint("s(", asNames[i], ")"), M_NAN, M_NAN, M_NAN, M_NAN,
                       TEXT_XLABEL);

              vT= fabs((mSim[][i]-vP[i])./sqrt(varc(mSim[][i])));
              [vX, vY]= DrawDensity(j+2*sizerc(vP), vT', asEst[iEstSV], TRUE,
                                    FALSE, FALSE,  FALSE, FALSE, 0,
                                    2+iEstSV);
              DrawText(j+2*sizerc(vP), sprint("t(", asNames[i], ")"), M_NAN, M_NAN, M_NAN, M_NAN,
                       TEXT_XLABEL);
              vMaxY[j+2*sizerc(vP)]= max(vMaxY[j+2*sizerc(vP)], vY);                                       
            } 
        }              
      // Draw truth
      iK= sizerc(vP); 
      for (i= 0; i < iK; ++i)
        DrawXMatrix(i, 0~vMaxY[i], "", vP[i]~vP[i], "", 0, 1);
      for (i= 0; i < iK; ++i)
        DrawXMatrix(i+2*iK, 0~vMaxY[i+2*iK], "",
                    quant(0.975, iK)~quant(0.975, iK), "", 0, 1);
      DrawTitle (-1, sprint("n= ", vSample[iSample], ", ", asEst[g_bGenrSV]));
      SaveDrawWindow(sprint(g_Outbase, g_bGenrSV, "_", vSample[iSample],
                            "pars"~CH_FIGEXT));
      ShowDrawWindow();   
    }  
}

/*
**  PlotParameters()
*/
PlotSParameters(const ssfsv, const amSim, const asEst, const vSample,
                const asTest, const mGenrSV, const iT)
{
  decl iS, iE, iSample, iEstSV, i, j, asPlot, asNames, 
       vX, vY, vP, iK, mSV;
  
  iS= sizerc(vSample);
  iE= sizeof(asEst);
  
  mSV= mGenrSV == <> ? <CMP_SV, 0, 0, 0> :
       mGenrSV;
  ssfsv.ChooseModel(g_mStsm);
  ssfsv.ChooseModel(g_mStsm|mSV);
  vP= ssfsv.GetFreePar();
  asPlot= ssfsv.GetFreeParNames();

  for (iSample= 0; iSample < iS; ++iSample)
    {
      for (iEstSV= 0; iEstSV < iE; ++iEstSV)
        {
          mSV= iEstSV == 0 ? <> :
               iEstSV == 1 ? CMP_SV~g_vSV[0]~0~g_vSV[1] :
               CMP_SV~g_vSV[0]~0~1;
          ssfsv.ChooseModel(g_mStsm|mSV);
          iK= ssfsv.GetFreeParCount();
          asNames= ssfsv.GetFreeParNames();

          for (i= 0; i < iK; ++i)
            {
              j= strfind(asPlot, asNames[i]);
              [vX, vY]= DrawDensity(j, amSim[iSample][iEstSV][][i+iK]', asEst[iEstSV], TRUE,
                                    FALSE, FALSE, FALSE, FALSE, 0,
                                    2+iEstSV);
              DrawText(j, sprint("s(", asNames[i], ")"), M_NAN, M_NAN, M_NAN, M_NAN,
                       TEXT_XLABEL);
            } 
        }              
      DrawTitle (-1, sprint("n= ", vSample[iSample], ", ", asEst[g_bGenrSV]));
      SaveDrawWindow(sprint(g_Outbase, g_bGenrSV, "_", vSample[iSample],
                            "spars"~CH_FIGEXT));
      ShowDrawWindow();   
    }  
}

