#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
listcomprehension.py

Purpose:
    Show an example of a list comprehension

Version:
    1       First start

Date:
    2017/8/15

Author:
    Charles Bos
"""
###########################################################
### Imports
import numpy as np
import pandas as pd

###########################################################
### main
def main():
    # Magic numbers
    iK= 5
    iN= 100

    # Initialisation
    rng= np.random.default_rng()
    mX= rng.normal(size=(iN, iK))         # Get n x k random N(0,1)

    # Estimation
    mS2= np.cov(mX.T)

    # Get standard errors, square root of diagonal elements of mS2
    vS= [np.sqrt(mS2[i,i]) for i in range(iK)]

    # Output
    print ("Covariance matrix of X:\n", pd.DataFrame(mS2))
    print ("Standard errors:\n", pd.DataFrame(vS))

###########################################################
### start main
if __name__ == "__main__":
    main()
