#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
plot1.py

Purpose:
    Display simple capabilities of matplotlib

Version:
    1       First start
    1b      Using explicit references to fig/axes

Date:
    2017/8/18

Author:
    Charles Bos
"""
###########################################################
### Imports
import numpy as np
import matplotlib.pyplot as plt

###########################################################
### main
def main():
    # Magic numbers
    iN= 100
    iK= 3

    # Initialisation
    mY= np.random.randn(iN, iK)

    # Output
    fig= plt.figure(figsize=(8, 6))      # Choose alternate size
    ax=fig.add_subplot(2, 1, 1)          # Work with 2x1 grid, first plot
    ax.plot(mY)                          # Simply plot the white noise
    ax.legend(["a", "b", "c"])           # Add a legend
    ax.set_title("White noise")          # ... and a title

    ax2=fig.add_subplot(2, 1, 2)         # Start with second plot
    ax2.plot(mY[:,0], mY[:,1:], ".")     # Plot here some cross-plots
    ax2.set_ylabel("b,c")
    ax2.set_xlabel("a")
    ax2.set_title("Unrelated data")      # ... and name the graph
    fig.savefig("graphs/plot1b.png")     # Save the result
    fig.show()                           # Done, show it

###########################################################
### start main
if __name__ == "__main__":
    main()
