#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
plot2.py

Purpose:
    Display simple capabilities of matplotlib

Version:
    2       Show line type, cross plots, etc.

Date:
    2017/8/18

Author:
    Charles Bos
"""
###########################################################
### Imports
import numpy as np
import matplotlib.pyplot as plt

###########################################################
### main
def main():
    # Get some random numbers
    iT= 100
    mY= np.random.randn(iT, 2)

    plt.subplot(2, 1, 1)            # Work with 2x1 grid, first plot
    plt.plot(mY, '.')               # Simply plot the white noise, with dots
    plt.legend(['a', 'b'])          # Add a legend

    # Put in confidence bounds
    plt.plot([0, iT-1], [[-1.96, 1.96], [-1.96, 1.96]], 'b-')
    plt.title('White noise')        # ... and a title

    plt.subplot(2, 1, 2)            # Start with second plot
    plt.plot(mY[:,0], mY[:,1], 'bx', label='a x b')   # Crossplot, blue crosses
    plt.xlabel('a')
    plt.ylabel('b')
    plt.title('Unrelated data')     # ... and name the graph
    plt.savefig('graphs/plot2.png') # Save the result
    plt.show()                      # Done, show it

###########################################################
### start main
if __name__ == "__main__":
    main()
