#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
plot_latex.py

Purpose:
    Display simple capabilities of matplotlib with latex

Version:
    2       Show line type, cross plots, etc.

Date:
    2017/8/18

Author:
    Charles Bos
"""
###########################################################
### Imports
import numpy as np
import matplotlib.pyplot as plt

###########################################################
### main
def PlotY(mY, bTex=False):

    plt.rc('text', usetex=bTex)

    plt.figure(figsize=(8,4))
    plt.plot(mY, '.')               # Simply plot the white noise, with dots

    plt.legend([r'$E=m C^2$', r'$s=\sum_{i=1}^n y_j$'])          # Add a legend

    if (bTex):           # ... and a LaTeX title
        plt.title(r'Use \textbf{(most)} \LaTeX\ commands {\em at will}')
    else:                # ... only if this is true tex output...
        plt.title(r'Only most simple LaTeX allowed h$\epsilon\rho\epsilon$')

    plt.savefig('graphs/plot_latex%i.png' % bTex) # Save the result
    plt.show()                      # Done, show it

###########################################################
### main
def main():
    # Magics
    iT= 100

    # Initialise
    mY= np.random.randn(iT, 2)
    PlotY(mY, bTex=True)
    PlotY(mY, bTex=False)

###########################################################
### start main
if __name__ == "__main__":
    main()
