#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
matrix.py

Purpose:
    Create and handle matrices

Version:
    1       Based on variables.py

Date:
    2017/7/13

Author:
    Charles Bos
"""
###########################################################
### Imports
import numpy as np
# import matplotlib.pyplot as plt

###########################################################
### main
def main():

    lX= [1, 2, 3]                   # A one-dimensional list
    lY= [[1, 2, 3], [4, 5, 6]]      # A two-dimensional list

    aX= np.array(lX)
    print ("A one-dimensional array of integers: aX= ", aX)

    aX= np.array(lX, dtype=float)
    print ("A one-dimensional array of floats: aX= ", aX)

    vXr= np.array(lX, dtype=float).reshape(1, np.size(lX))
    print ("A two-dimensional row vector vXr=\n", vXr)
    vXc= np.array(lX, dtype=float).reshape(np.size(lX), 1)
    print ("A two-dimensional column vector vXc=\n", vXc)

    mY= np.array(lY, dtype=float)
    print ("mY: \n", mY)

    mZ= mY @ vXc
    print ("Matrix multiplication Z= mY @ vXc:\n", mZ)

    mZ= vXr * mY
    print ("Element by element multiplication Z= vXr * mY:\n", mZ)

###########################################################
### start main
if __name__ == "__main__":
    main()
