#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
matrix2.py

Purpose:
    Show some effects of matrices

Version:
    1       First start

Date:
    2019/8/22

Author:
    Charles Bos
"""
###########################################################
### Imports
import numpy as np

###########################################################
### main
def main():
    # Magic numbers
    (iR, iC)= (3, 4)

    # Initialisation
    mX= np.random.randn(iR, iC)

    # Estimation
    print ("Initial mX:\n", mX)

    dSum= np.sum(mX)
    print ("mX as argument of a function: sum=%g" % dSum)
    dSum2= mX.sum()
    print ("Applying a function to mX: sum=%g" % dSum2)
    vSum= mX.sum(axis=0)
    print ("Applying a function to mX along axis 0: vsum=\n", vSum)
    vX= mX.reshape(1, 12)
    print ("Applying a function to reshape mX: vX becomes\n", vX)
    print ("But note that mX is not changed, mX:\n", mX)

    mX.shape= (1, iR*iC)
    print ("Altering a characteristic, mX:\n", mX)

###########################################################
### start main
if __name__ == "__main__":
    main()
