#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
pandas_print.py

Purpose:
    Example using pandas, printing some (fake) results

Version:
    1       First start

Date:
    2020/8/15

Author:
    Charles Bos
"""
###########################################################
### Imports
import numpy as np
import pandas as pd

###########################################################
### main
def main():
    # Magic numbers
    vP0= [0.5, 1, 4]
    vP= [0.745, .986, 3.74]
    vS= [.045, .062, .254]


    # Initialisation
    vP0= np.array(vP0)
    vP= np.array(vP)
    vS= np.array(vS)

    asR= ['B0', 'B1', 's2']
    asC= ['p0', 'pHat', 'sHat']
    mRes= np.vstack([vP0, vP, vS]).T        # Stack underneath, transpose
    df= pd.DataFrame(mRes, index=asR, columns=asC)

    # Output
    print ("Simply printing the dataframe:")
    print (df)
    print ("\nPrinting the dataframe towards LaTeX:")
    print (df.to_latex(float_format='%6.3f'))

###########################################################
### start main
if __name__ == "__main__":
    main()
