#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
shoes.py

Purpose:
    Example using pandas. Note that this program is meant to be run line-by-line, not as a stand-alone program.

Version:
    1       First start

Date:
    2020/8/11

Author:
    Charles Bos
"""
###########################################################
### Imports
import numpy as np
import pandas as pd
import matplotlib.pyplot as plt

###########################################################
### main
def main():
    # Magic numbers
    sData= 'shoesize_bk2020'

    # Initialisation
    df= pd.read_csv('data/%s.csv' % sData)     # DataFrame
    sf= df['Gender']                           # Series

    # Output
    print ('Type df: %s\nType sf: %s' % (type(df), type(sf)))

    # Alternative: Create dataframe here, from a matrix
    dfR= pd.DataFrame(np.random.randn(10,4), columns=['a', 'b', 'c', 'd'])
    print (dfR)
    print (dfR.to_latex(float_format='%.4f'))

    print ('Head of df: \n', df.head())
    print ('Tail of sf:\n', sf.tail(), sep='')

    # Information
    df
    df.shape
    df.size
    df.columns
    df.index
    df.groupby('Gender').mean()
    df.head()
    df.info()
    df.describe()
    df.mean(axis=0)
    df.var()

    # Indexing
    asC= ['Shoesize', 'Length'];
    asR= range(4, 8)

    df[asC]
    df.loc[asR,:]
    df.loc[asR,asC]
    df.iloc[3,2]

    type(df)
    mX= df.values
    type(mX)
    mX
    # Advanced indexing
    vI= df['Gender'] == 'Male'
    vI.name= 'MaleGender'
    dfM= df[vI]
    df[vI]['Length'].mean()

    df[ df['Gender'] == 'Male']['Length'].mean()

    df1= df.pivot(columns='Gender', values=['Shoesize', 'Length'])
    df1[asC].mean()
    df1.columns
    df1[('Shoesize', 'Male')].mean()
    df1['Shoesize'].mean()

    # Saving
    df.to_csv('data/%s_out.csv' % sData, index=False)
    df.to_csv('data/%s_out.csv.gz' % sData)
    df.to_excel('data/%s_out.xlsx' % sData, sheet_name='BK2020 shoe sizes vs length')
    df.to_excel('data/%s_out.ods' % sData, index=False)

    # Plotting
    df.plot.area(figsize=(8,4))
    df.plot.area(subplots=True)
    df.plot.density(subplots=True)

    # Plot and save a figure
    plt.figure()
    df.plot.box(figsize=(8,3))
    plt.savefig('graphs/shoesize_box.png')
    plt.show()

    # Output
    print ('This is a program meant to be run line-by-line.\n')

###########################################################
### start main
if __name__ == "__main__":
    main()
