#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
exrandom_legacy.py

Purpose:
    Display usage of legacy random number generators

Version:
    1       First start

Date:
    2024/6/30

Author:
    Charles Bos
"""
###########################################################
### Imports
import numpy as np

###########################################################
### main
def main():
    # Magic numbers
    iSeed= 1234
    iN= 100

    # Initialisation
    np.random.seed(iSeed)   # Initialise the random number generator/seed

    # Estimation
    vY= np.random.randn(iN)

    # Output
    print (f'Mean and variance of {iN} draws from N(0, 1): m= {np.mean(vY):.4f}, s2= {np.var(vY):.4f}')

###########################################################
### start main
if __name__ == "__main__":
    main()
