#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
recap8.py

Purpose:
    Alter arguments to function

Date:
    2017/7/17

Author:
    Charles Bos
"""
###########################################################
### Imports
import numpy as np

###########################################################
### func_nochange(mX)
def func_nochange(mX):
    mX= np.random.randn(3, 4)
    print ('In func_nochange, changing mX locally to mX=\n', mX)

###########################################################
### func_change(mX)
def func_change(mX):
    iR, iC= mX.shape
    mX[:,:]= np.random.randn(iR, iC)
    print ('In func_change, changing mX locally to mX=\n', mX)

###########################################################
### main
def main():
    mX= np.array([[1.0,2,3],[4,5,6]])
    func_nochange(mX)
    print ('In main, after func_nochange: mX=\n', mX)
    func_change(mX)
    print ('In main, after func_change: mX=\n', mX)

###########################################################
### start main
if __name__ == "__main__":
    main()
