#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
inctime.py

Purpose:
    Show timing

Version:
    1       First start

Date:
    2018/8/29

Author:
    Charles Bos
"""
###########################################################
### Imports
import time
import numpy as np

###########################################################
class Timer(object):
    """
    Purpose:
        Measure time of a block of code
    """
    def __init__(self, name=None):
        self.name = name

    def __enter__(self):
        self.tstart = time.time()

    def __exit__(self, type, value, traceback):
        if self.name:
            print ('[%s]' % self.name),
        print ('Elapsed: %s' % (time.time() - self.tstart))

###########################################################
### main
def main():
    # Magic numbers
    iR= 10
    iN= 1000
    iK= 500

    print ("Timing a simple loop:")
    with Timer("Short loop"):
        for i in range(iR):
            mX= np.random.randn(iN, iK)

###########################################################
### start main
if __name__ == "__main__":
    main()
